// Top Secret Crypto Gold for Windows
//...................................

// Copyright  2000 - 2005 by TAN$TAAFL Software Company
//						      14 Foster St., Banician
//                            Olongapo City 2200
//                            Philippines

// This source code is NOT IN THE PUBLIC DOMAIN and is NOT OPEN SOURCE.
// It is provided solely for the purpose of letting you determine how
// the program works, and that there are no backdoors or hidden code
// in the program. Anyone that wants to use any portion of this code
// in their own program please contact the author at:

//							  MacGregor K. Phillips
//                            PSC 517 Box RS
//                            FPO AP 96517-1000

// Procedures for packing and unpacking files.
//............................................
#include <windows.h>  
#include "Tsc.h"
#include "ContextHelp.h"
#include "Prototypes.h"
#include <Shlwapi.h>
#include <Commctrl.h>
#include <htmlhelp.h>
#include <shellapi.h>
#include <shlobj.h>
#include "Tscmsg.h"
#include "Check.h"
#include "zlib.h"
#define STRSAFE_LIB
#include <strsafe.h>

extern	HINSTANCE			hInst;
extern	LPTSTR				lpszNA;
extern	HWND				hMainWindow;
extern	LPCTSTR				lpszAppName;
extern	LPCTSTR				lpIconPointer;
extern	HWND				hDialogModeLess;
extern	HWND				hDlgCurrent;
extern	BOOL				bProcessInProgress;
extern	BOOL				bCancelOperation;
extern	LPBYTE				lpFileName;
extern	LPBYTE				lpFileExtension;
extern	HICON				hIcon;
extern	TCHAR				szDestination[MAX_PATH];
extern	LPBYTE				lpDestinationFileName;
extern	LPTSTR				lpszSizeFormat;
extern	NUMBERFMT			nFormatInfo;
extern	LPBYTE				lpCrc32Table;
extern	int					iWhichAviClip;
extern	int					iStepIncrement;
extern	BOOL				bAviClipOK;
extern	HWND				hAviClip;
extern	HWND				hStatusBar;
extern	TCHAR				szFileName[MAX_PATH];
extern	int					iNumberOfFiles;
extern	HANDLE				hOutPutFile;
extern	TCHAR				szBackUpFile[MAX_PATH];
extern	HANDLE				hBackUpFile;
extern	int					iWhichAviClip;
extern	LPTSTR				lpszDateTimeFormat;
extern	SHFILEINFO			shfi1;
extern	BOOL				bWipeFiles;
extern	BOOL				bUseNew;
extern	LPCTSTR				lpszInformation;
extern	BOOL				bIntermediatePkd;
extern	BOOL				bAa;
extern	BOOL				bRestrictionsInEffect;
extern	BOOL				bUseMd5;
extern	z_stream			z;
extern	LARGE_INTEGER		liEncFileSize;
extern	LARGE_INTEGER		liSegment;
extern	TCHAR				szPreviousDestinationDir[MAX_PATH];
extern	HFONT				hDlgFont;
extern	BOOL				bWin2000OrGreater;
extern	BOOL				bShowPreviousEncFolder;
extern	CONFIG				cfg;
extern	DWORD				dwStringSafeFlag;

// HASH TABLE IS ALWAYS ABOUT 15% LARGER THAN THE CODE TABLE AND
// IS A PRIME NUMBER. THIS SPEEDS UP COMPRESSION BY ABOUT 50%.
// ------------------------------------------------------------------
//  CODE		 CODE	     CODE		 HASH	     HASH      PSEUDO
//  BITS		TABLE	     SIZE		TABLE	     SIZE	    STACK
// ------------------------------------------------------------------
//   14        16,384	   81,920      19,069	   76,276      16,384
//   15        32,768	  163,840      35,023	  140,092      32,768
//   16        65,536	  327,680      78,643	  314,572      65,536
//   17       131,072	  655,360     157,291	  629,164     131,072
//   18       262,144	1,310,720     314,581	1,258,324     262,144
//   19       524,288	2,621,440     629,171	2,516,684     524,288
//   20     1,048,576	5,242,880   1,258,291	5,033,164   1,048,576
//   21     2,097,152  10,485,760   2,516,603  10,066,412   2,097,152
//   22     4,194,304  20,971,520   5,033,167  20,132,668   4,194,304
//   23     8,388,608  41,943,040  10,066,337  40,265,348   8,388,608
//   24    16,777,216  83,886,080  20,132,683  80,530,732  16,777,216

// TOTAL EXTENDED MEMORY REQUIRED FOR PACKING AND UNPACKING.
//..........................................................
//	          PACKING	 UNPACKING
//   14       158,196	    98,304
//   15       303,932	   196,608
//   16       642,252	   393,216
//   17     1,284,524	   786,432
//   18     2,569,044	 1,572,864
//   19     5,138,124	 3,145,728
//   20    10,276,044	 6,291,456
//   21    20,552,172	12,582,912
//   22    41,104,188	25,165,824
//   23    82,208,388	50,331,648
//   24   164,416,812  100,663,296

// Stats for the various bit sizes used from 14 to 24.
//....................................................
CODE_STATS	CodeStats[] = 
{
	{14,   16384,   81920,   76276,   16384,   158196,   98304},
	{15,   32768,  163840,  140092,   32768,   303932,  196608},
	{16,   65536,  327680,  314572,   65536,   642252,  393216},
	{17,  131072,  655360,  629164,  131072,  1284524,  786432},
	{18,  262144, 1310720, 1258324,  262144,  2569044,  1572864},
	{19,  524288, 2621440, 2516684,  524288,  5138124,  3145728},
	{20, 1048576, 5242880, 5033164, 1048576, 10276044,  6291456},
	{21, 2097152,10485760,10066412, 2097152, 20552172, 12582912},
	{22, 4194304,20971520,20132668, 4194304, 41104188, 25165824},
	{23, 8388608,41943040,40265348, 8388608, 82208388, 50331648},
	{24,16777216,83886080,80530732,16777216,164416812,100663296},
};

// Variables used to hold the size of the code, hash, and stack tables.
//.....................................................................
DWORD				dwCodeTableSize;
DWORD				dwHashTableSize;
DWORD				dwPStackSize;
int					iMaxPack= 24;
int					iRealMaxPack;
int 				iMaxUnpack;
int					iSetBitSizeTo;

// The following change according to the max number of bits
// in a LZW code.
//..........................................................
DWORD				dwMaxCode;
DWORD				dwResetTable;
DWORD				dwResetCode;
DWORD				dwHashTableEntries;
BYTE				CharacterShiftValue;

// Variables for the compression and decompression procedures.
//............................................................
ULARGE_INTEGER		uliTotalCodes;
LARGE_INTEGER		liHalfPercent;
LARGE_INTEGER		liHalfPercentDup;
int					iFilesUnpacked;
LPBYTE				lpStackPointer;
ULARGE_INTEGER		uliFileIn;
ULARGE_INTEGER		uliFileOut;
ULARGE_INTEGER		uliInCount;
ULARGE_INTEGER		uliOutCount;
ULARGE_INTEGER		uliFinalFileSize;
DWORD				dwCodesUsed;
DWORD				dwOldCode;
DWORD				dwInCode;
ULARGE_INTEGER		uliFileCodes;
HANDLE				hInputFile;
DWORD				dwCodeHoldArea;
DWORD				dwCurrentLevel;
int					iBitsLeft;
DWORD				dwBitsLeft;
DWORD				dwBitsInCode;
DWORD				dwStuffPtr;
DWORD				dwPassCrc32;
BOOL				bDeleteUnpackedFile;
DWORD				dwCheckCrc32;
BOOL				bOverWriteAll;
HICON				hIcon2;
BOOL				bWipeAfterPacking;
OPENFILENAME		ofnPack;
BOOL				bWipeAfterUnpacking;
BOOL				bWeHaveLzw;
BOOL				bEncryptIt = TRUE;
BOOL				bAlreadyPacked;
LPBYTE				lpFileInsert;

// Bit mask table.
//................
DWORD				dwBitMask[] = {0x1ff,		// 9 bits
								   0x3ff,		// 10 bits
								   0x7ff,		// 11 bits
								   0xfff,		// 12 bits
								   0x1fff,		// 13 bits
								   0x3fff,		// 14 bits
								   0x7fff,		// 15 bits
								   0xffff,		// 16 bits
								   0x1ffff,		// 17 bits
								   0x3ffff,		// 18 bits
								   0x7ffff,		// 19 bits
								   0xfffff,		// 20 bits
								   0x1fffff,	// 21 bits
								   0x3fffff,	// 22 bits
								   0x7fffff,	// 23 bits
								   0xffffff,};	// 24 bits

// Buffer pointers required by the procedures.
//............................................
LPBYTE				lpInBuffer;
LPBYTE				lpOutBuffer;
LPBYTE				lpHashTable;
LPTABLE				lpCodeTable;
LPBYTE				lpPStack;
BOOL				bEndOfFile;
DWORD				dwSizeInBuffer;
DWORD				dwGetPtr;
LPBYTE				lpAppendPtr;
LPBYTE				lpAppendExt;
DWORD				dwBufferCount;
DWORD				dwBufferSize;
DWORD				dwOutPutCount;
BYTE				Temp;
BYTE				LastByte;

// Extensions for packed files.
//.............................
LPCTSTR				lpszCabFile = "*.cab";
LPCTSTR				lpszArcFile = "*.arc";
LPCTSTR				lpszArjFile = "*.arj";
LPCTSTR				lpszPkdFile = "*.pkd";
LPCTSTR				lpszLzhFile = "*.lzh";
LPCTSTR				lpszZipFile = "*.zip";

BOOL				bNeedDestination;

// Memory status register.
//........................
MEMORYSTATUS		mst;

// Pack and unpack formating code size string.
//............................................
TCHAR				szPackCode[] = "Pack: %d Bits  Unpack: %d Bits";
TCHAR				szResults[] = "Files to unpack: %d. %u out of %u unpacked files passed their integrity checks.";

// Headers for the packed file.
//.............................
PACKED_FILE_HEADER	pfhdr;
PACKED_FILE_ID_HDR	pfidhdr;

BYTE				PackedFileId[] = "pkd1";
BYTE				PackedFileId1[] = "DC32";

// Header for a file using the zip algorithms.
//............................................
BYTE				PackedFileIdZ[] = "pkd2";
TCHAR				szLevel[] = "Compression Level: Maximum Compression";

LPBYTE				lpFileReturn1;

// Unpack a packed file.
//......................
BOOL UnpackAFile(LPBYTE lpPkdFile)
{
	ULARGE_INTEGER		uliFreeCallerBytes;
	ULARGE_INTEGER		uliTotalBytes;
	ULARGE_INTEGER		uli;
	LARGE_INTEGER		liStats;
	OPENFILENAME		ofn;
	DWORD				dwOldHelpTopic;
	DWORD				dwBytesRead;
	DWORD				dwBytesToRead;
	DWORD				dwBytesWritten;
	DWORD				dwDestinationLength;
	DWORD				dwLastError;
	BOOL				bDiskError;
	BOOL				bError;
	BOOL				bResult;
	int					iResult;
	LONG				lResult;
	HRESULT				hr = ERROR_SUCCESS;
	BROWSEINFO			bi;
    LPITEMIDLIST		lpidl;
    LPMALLOC			lpMalloc;
	UINT				uiDriveType;
	TCHAR				szRoot[16];
	TCHAR				szPackedFileName[MAX_PATH];
	TCHAR				szOutBuffer[132];
	
	bProcessInProgress = TRUE;
	dwOldHelpTopic = ChangeHelpTopic(IDH_UNPACK);
	bAviClipOK = FALSE;
	bDiskError = FALSE;
	bError = TRUE;
	bOverWriteAll = FALSE;
	bWipeAfterUnpacking = FALSE;
	liSegment.QuadPart = 0;

	if (BPC())
	{
		goto UnpackEnd;
	}
	// Initialize the OPENFILENAME structure.
	//.......................................
	InitializeOFN(&ofn,SAVE_SOURCE);

	if (!lpPkdFile)
	{
		// Initialize with specific information for this procedure.
		//.........................................................
		ofn.lpstrFile = szFileName;
		ofn.nMaxFile = sizeof(szFileName);
		ofn.hwndOwner = hMainWindow;
		
		ofn.lpstrFilter = TEXT("Packed Files [.pkd]\0*.pkd\0All Files [*.*]\0*.*\0");
		ofn.nFilterIndex = 1;
		ofn.lpstrTitle = TEXT("Select a Packed File to Unpack");
		ofn.Flags = (OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST |
					 OFN_ENABLEHOOK | OFN_ENABLESIZING | OFN_SHOWHELP | OFN_HIDEREADONLY);
		ofn.lpstrDefExt = NULL;

		// Allow wipe original if no admin account or admin allows it.
		//............................................................
		if (!bAa || (bAa && (cfg.V1.dwV3 & PERMIT_WIPE_ORIGINAL)) || 
		   (bAa && !bRestrictionsInEffect))
		{
			if (bWin2000OrGreater)
			{
				ofn.lpTemplateName = TEXT("WIPEPACKEDFILENEW");
			}
			else
			{
				ofn.lpTemplateName = TEXT("WIPEPACKEDFILE");
			}
			ofn.lpfnHook = MyUnpackOFNHookProc;
			ofn.Flags |= OFN_ENABLETEMPLATE;
			ofn.hInstance = hInst;
		}
		else
		{
			ofn.lpfnHook = MyOFNHookProc;
		}
		// Setup the icon to use in the caption bar.
		//..........................................
		lpIconPointer = lpszAppName;

		while(TRUE)
		{
			ZeroMemory(&szFileName,sizeof(szFileName));
	
			// Select the file to unpack.
			//...........................
			if (!GetOpenFileName(&ofn))
			{
				CommDlgBoxErrorProc(IDS_GET_FILES);
				goto UnpackEnd;
			}
			// Save the dir name.
			//...................
			SaveDirName((LPBYTE)&szFileName,SAVE_SOURCE,TRUE);

			// Make sure the file is a valid packed file.
			//...........................................
			hInputFile = IsValidPackedFile((LPBYTE)&szFileName,TRUE);

			if (hInputFile)
			{
				break;
			}
		}
	}
	lpFileName = PathFindFileName((LPCTSTR)&szFileName);
	lpFileExtension = PathFindExtension((LPCTSTR)&szFileName);
	EmptyTheMessageQue();

	// Setup the step increment for the progress bar.
	// Always equals one for this case.
	//...............................................
	iStepIncrement = 1;

	iNumberOfFiles = pfidhdr.iFilesInVault;

	// Determine the size of the file so we can determine how much
	// a half percent is.
	//............................................................
	uli.QuadPart = GetMyFileSize((LPTSTR)&szFileName,hInputFile);
	if (uli.QuadPart == -1)
	{
		goto UnpackEnd;
	}
	if (uli.QuadPart < 40000)
	{
			__asm
			{
				xor		edx,edx
				mov		eax,uli.LowPart
				mov		ecx,200
				div		ecx
				cmp		eax,edx
				jae		L1
				inc		eax
			L1:	mov		liHalfPercent.HighPart,0
				mov		liHalfPercent.LowPart,eax
			}
	}
	else
	{
		liHalfPercent.QuadPart = (uli.QuadPart / 200);
		if (liHalfPercent.QuadPart == 0)
		{
			liHalfPercent.QuadPart = 1;
		}
	}
	liHalfPercentDup.QuadPart = liHalfPercent.QuadPart;

	// Select a destination for the unpacked files.
	//.............................................
	if (!lpPkdFile)
	{
		while(TRUE)
		{
			SetCurrentDirectory((LPCTSTR)&szPreviousDestinationDir);
			ZeroMemory(&szDestination,sizeof(szDestination));

			if (SUCCEEDED(SHGetMalloc(&lpMalloc))) 
			{
				ZeroMemory(&bi,sizeof(bi));
				bi.hwndOwner = hMainWindow;
				bi.pszDisplayName = 0;
				bi.lpszTitle = TEXT("Select a Destination for the unpacked file(s).");
				bi.pidlRoot = 0;
				bi.ulFlags = BIF_RETURNONLYFSDIRS;

				// If we can use the new style of the dialog box, do it.
				//......................................................
				if (bUseNew)
				{
					hr = CoInitialize(NULL);
					if (SUCCEEDED(hr))
					{
						bi.ulFlags |= BIF_NEWDIALOGSTYLE;
					}
				}
				bi.lpfn = BrowseCallbackProc;

				lpidl = SHBrowseForFolder(&bi);

				if (bUseNew && SUCCEEDED(hr))
				{
					CoUninitialize();
				}
				if (lpidl) 
				{
					bResult = SHGetPathFromIDList(lpidl,(LPSTR)&szDestination);
					lpMalloc->lpVtbl->Free(lpMalloc,lpidl);
					lpMalloc->lpVtbl->Release(lpMalloc);
				}
				else
				{
					// We cancelled out.
					//..................
					goto UnpackEnd;
				}
				// Save the dir name.
				//...................
				SaveDirName((LPBYTE)&szDestination,SAVE_DESTINATION,FALSE);

				// See if we have any free disk space. cd rom drives that
				// are not writable will report zero.
				//.......................................................
				ZeroMemory(&szRoot,sizeof(szRoot));
				CopyMemory(&szRoot,&szDestination,3);
				bResult = GetDiskFreeSpaceEx((LPCTSTR)&szRoot,
											(PULARGE_INTEGER)&uliFreeCallerBytes.QuadPart,
											(PULARGE_INTEGER)&uliTotalBytes.QuadPart,NULL);
				if (!bResult)
				{
					ErrorProcedure((LPTSTR)&szDestination,IDS_GETFREEDSKSPACE,MB_OK);
					goto UnpackEnd;
				}
				if (uliFreeCallerBytes.QuadPart == 0)
				{
					SetLastError(IDS_NOSPACE);
					ErrorProcedure((LPTSTR)&szDestination,IDS_GETFREEDSKSPACE,MB_OK);
					continue;
				}
				if (uliFreeCallerBytes.QuadPart < 
					pfidhdr.uliTotalSizeOfFiles.QuadPart)
				{
					SetLastError(IDS_INSUFFICIENTSPACE);
					ErrorProcedure((LPTSTR)&szDestination,IDS_GETFREEDSKSPACE,MB_OK);
					continue;
				}
				// If we got this far with no error, we have a valid
				// destination.
				//..................................................
				break;
			}
			else
			{
				MessageBoxProc(hMainWindow,IDS_SYSTEM_ERROR,IDS_SELECTDIR,
							   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
				goto UnpackEnd;
			}
		}
	}
	EmptyTheMessageQue();

	// Get the drive type so we can determine which
	// avi clip to use.
	//.............................................
	CopyMemory(&szRoot,&szDestination,3);
	uiDriveType = GetDriveType((LPCTSTR)&szRoot);

	// Add a backslash to the destination if we need one.
	//...................................................
	lpAppendPtr = PathAddBackslash((LPTSTR)&szDestination);
	dwDestinationLength = lstrlen((LPCTSTR)&szDestination);

	// Setup the avi clip we will use.
	//................................
	iWhichAviClip = FILE_COPY;
	if (uiDriveType == DRIVE_REMOVABLE && (*szDestination == 0x41 ||
		*szDestination == 0x61 || *szDestination == 0x42 || *szDestination == 0x62))
	{
		iWhichAviClip = FILE_DISK;
	}
	else if (uiDriveType == DRIVE_CDROM)
	{
		iWhichAviClip = FILE_CDROM;
	}
	// Build a crc32 table, allocate memory, and initialize a few
	// variables.
	//...........................................................
	bResult = Crc32Table(BUILD_TABLE);
	if (!bResult)
	{
		goto UnpackEnd;
	}
	lpInBuffer = AllocateMemory(BUFFER_SIZE_IN);
	lpOutBuffer = AllocateMemory(BUFFER_SIZE_OUT);
	if (!lpInBuffer || !lpOutBuffer)
	{
		goto UnpackEnd;
	}
	dwPassCrc32 = 0;
	iFilesUnpacked = 0;

	// Setup the modeless dialog box for unpacking our files.
	//.......................................................
	bCancelOperation = FALSE;
	hDialogModeLess = CreateDialog(hInst,TEXT("UNPACKFILES"),hMainWindow,
								  (DLGPROC)UnpackFilesProc);

	if (!hDialogModeLess)
	{
		ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
		goto UnpackEnd;
	}
	// Start the avi clip.
	//....................
	if (bAviClipOK)
	{
		bAviClipOK = Animate_Play(hAviClip,0,-1,-1);
	}
	// Process the packed files.
	//..........................
	while(iNumberOfFiles > 0)
	{
		EmptyTheMessageQue();
		if (bCancelOperation == TRUE)
		{
			goto UnpackEnd;
		}
		// Read in a header entry.
		//........................
		ZeroMemory(&szPackedFileName,MAX_PATH);
		bResult = ReadMyFile((LPTSTR)&szFileName,hInputFile,&pfhdr,
						      sizeof(PACKED_FILE_HEADER),&dwBytesRead,NULL);

		// If we did not read in the required number of bytes.
		//....................................................
		if (dwBytesRead != sizeof(PACKED_FILE_HEADER))
		{
			SetLastError(IDS_BYTESREADNOTEQUALTOREQUEST);
			ErrorProcedure((LPTSTR)&szFileName,IDS_READ,MB_OK);
			goto UnpackEnd;
		}
		if (!bResult)
		{
			goto UnpackEnd;
		}
		// Check the header crc32 value.
		//..............................
		bResult = CheckHeaderCrc();
		if (!bResult)
		{
			goto UnpackEnd;
		}
		// Read in the file name which follows the header.
		//................................................
		bResult = ReadMyFile((LPTSTR)&szFileName,hInputFile,&szPackedFileName,
							  pfhdr.wLengthOfFileName,&dwBytesRead,NULL);

		// If we did not read in the required number of bytes.
		//....................................................
		if (dwBytesRead != pfhdr.wLengthOfFileName)
		{
			SetLastError(IDS_BYTESREADNOTEQUALTOREQUEST);
			ErrorProcedure((LPTSTR)&szFileName,IDS_READ,MB_OK);
			goto UnpackEnd;
		}
		if (!bResult)
		{
			goto UnpackEnd;
		}
		// See if the length of the file name and destination
		// exceeds max path.
		//...................................................
		if ((dwDestinationLength + pfhdr.wLengthOfFileName) > MAX_PATH)
		{
			SetLastError(IDS_PATHTOOLONGUNPACK);
			ErrorProcedure((LPTSTR)&szPackedFileName,IDS_CREATE_OPEN,MB_OK);

			// We have to get past the compressed data to the next
			// file header.
			//....................................................
			uli.QuadPart = SetMyFilePointer((LPTSTR)&szFileName,hInputFile,
											 pfhdr.uliCompressedFileSize.QuadPart,
											 FILE_CURRENT);
			if (uli.QuadPart == -1)
			{
				goto UnpackEnd;
			}
			iNumberOfFiles--;
			continue;
		}
		// Create the output file name.
		//.............................
		*lpAppendPtr = 0;
		StringCbCatEx((LPTSTR)&szDestination,sizeof(szDestination),(LPCTSTR)&szPackedFileName,
					   NULL,NULL,dwStringSafeFlag);
		lpAppendExt = PathFindExtension((LPCTSTR)&szDestination);

		// Setup the name and icon in the dialog boxs. 
		//............................................
		if (hIcon)
		{
			DestroyIcon(hIcon);
			hIcon = 0;
		}
		hIcon = FindMyIcon((LPBYTE)&szDestination,(LPBYTE)lpAppendExt);

		// If we did not find one, use the default.
		//.........................................
		if (!hIcon)
		{
			hIcon = LoadImage(hInst,"I_FACEFROWN",IMAGE_ICON,32,32,LR_SHARED);
		}
		// Create the file. If it exists in the destination ask if
		// we want to overwrite.
		//........................................................
		hOutPutFile = CreateFile((LPCTSTR)&szDestination,GENERIC_READ |
								  GENERIC_WRITE,0,NULL,CREATE_NEW,FILE_ATTRIBUTE_NORMAL,NULL);

		if (hOutPutFile == INVALID_HANDLE_VALUE)
		{
			hOutPutFile = 0;

			dwLastError = GetLastError();
			if (dwLastError == ERROR_FILE_EXISTS)
			{
				if (!bOverWriteAll)
				{
					FlashMyIcon(FALSE);

					// Ask if we want to override.
					//............................
					iResult = DialogBox(hInst,TEXT("ASKOVERWRITE"),hDialogModeLess,
									   (DLGPROC)AskOverwriteUnpackProc);

					// See if we had a system error in creating the 
					// dialog box.
					//.............................................
					if (iResult == -1)
					{
						ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
						goto UnpackEnd;
					}
					// Quit if we canceled.
					//.....................
					if (iResult == IDCANCEL)
					{
						goto FinalStats;
					}
					// No, do not overwrite this file.
					//................................
					if (iResult == IDC_MYNO)
					{
						// We have to get past the compressed data to
						// the next file header.
						//...........................................
						uli.QuadPart = SetMyFilePointer((LPTSTR)&szFileName,hInputFile,
													     pfhdr.uliCompressedFileSize.QuadPart,
														 FILE_CURRENT);
						if (uli.QuadPart == -1)
						{
							goto UnpackEnd;
						}
						iNumberOfFiles--;
						continue;
					}
				}
				if (bWeHaveLzw)
				{
					// We want to overwrite the file.
					// Check to see if we can unpack this file before we delete it.
					//.............................................................
					SetMaxCodeSizeOnStartUp();
					if (pfhdr.LargestBitCode <= iMaxUnpack)
					{
						hOutPutFile = CreateMyFile((LPTSTR)&szDestination,
												    GENERIC_READ | GENERIC_WRITE,0,NULL,
												    TRUNCATE_EXISTING,
													FILE_ATTRIBUTE_NORMAL,NULL);
						if (!hOutPutFile)
						{
							goto UnpackEnd;
						}
					}
				}
				else
				{
					// We want to overwrite a zipped file.
					//....................................
					hOutPutFile = CreateMyFile((LPTSTR)&szDestination,
												GENERIC_READ | GENERIC_WRITE,0,NULL,
												TRUNCATE_EXISTING,
												FILE_ATTRIBUTE_NORMAL,NULL);
					if (!hOutPutFile)
					{
						goto UnpackEnd;
					}
				}
			}
			else
			{
				SetLastError(dwLastError);
				ErrorProcedure((LPTSTR)&szDestination,IDS_CREATE_OPEN,MB_OK);
				goto UnpackEnd;
			}
		}
		bDiskError = TRUE;

		// We have a valid output file. Check to see if the file is
		// just stored or compressed. For zip always equal to 9.
		//.........................................................
		if (pfhdr.LargestBitCode == 0)
		{
			// Setup the name and icon of the file to restore.
			//................................................
			if (hIcon2)
			{
				DestroyIcon(hIcon2);
			}
			hIcon2 = hIcon;
			hIcon = 0;
			SendMessage(GetDlgItem(hDialogModeLess,IDC_ICON2),STM_SETICON,(WPARAM)hIcon2,0);

			SetDlgItemTextFmt(hDialogModeLess,IDC_FILE2,
							 (LPCTSTR)GetDisplayName(&shfi1,(LPCTSTR)&szDestination));

			EmptyTheMessageQue();

			dwCheckCrc32 = -1;
			uli.QuadPart = pfhdr.uliCompressedFileSize.QuadPart;
			liStats.QuadPart = 0;
			
			while(uli.QuadPart > 0)
			{
				if (uli.QuadPart > BUFFER_SIZE_IN)
				{
					dwBytesToRead = BUFFER_SIZE_IN;
					uli.QuadPart -= BUFFER_SIZE_IN;
				}
				else
				{
					dwBytesToRead = uli.LowPart;
					uli.QuadPart = 0;
				}
				bResult = ReadMyFile((LPTSTR)&szFileName,hInputFile,
									  lpInBuffer,dwBytesToRead,&dwBytesRead,NULL);
				// If we did not read in the required number of bytes.
				//....................................................
				if (dwBytesRead != dwBytesToRead)
				{
					SetLastError(IDS_BYTESREADNOTEQUALTOREQUEST);
					ErrorProcedure((LPTSTR)&szFileName,IDS_READ,MB_OK);
					goto UnpackEnd;
				}
				if (!bResult)
				{
					goto UnpackEnd;
				}
				// Calculate the crc32 check value.
				//.................................
				__asm
				{
					mov		edi,lpInBuffer
					mov		ecx,dwBytesRead
				L2:	mov		al,byte ptr [edi]
					xor		al,byte ptr dwCheckCrc32
					shr		dwCheckCrc32,8
					movzx	esi,al
					mov		ebx,lpCrc32Table
					mov		edx,dword ptr [ebx][esi*4]
					xor		dwCheckCrc32,edx
					inc		edi
					dec		ecx
					jnz		L2
				}
				// Write the input buffer to the destination file.
				//................................................
				bResult = WriteMyFile((LPTSTR)&szDestination,hOutPutFile,
									   lpInBuffer,dwBytesRead,&dwBytesWritten,NULL);
				if (!bResult)
				{
					goto UnpackEnd;
				}
				// Update the status bar to reflect this file.
				//............................................
				liStats.QuadPart += dwBytesRead;
				while(liStats.QuadPart >= liHalfPercentDup.QuadPart)
				{
					SendMessage(GetDlgItem(hDialogModeLess,IDC_PROGRESS),PBM_STEPIT,0,0);
					liStats.QuadPart -= liHalfPercentDup.QuadPart;
				}
			}
		}
		else
		{
			if (bWeHaveLzw)
			{
				// Check to see if we can unpack this file.
				//.........................................
				SetMaxCodeSizeOnStartUp();
				if (pfhdr.LargestBitCode > iMaxUnpack)
				{
					SetLastError(IDS_NOTENOUGHMEMORYTOUNPACK);
					lResult = ErrorProcedure((LPTSTR)&szDestination,IDS_ALLOCATEMEMORY,
											  MB_OKCANCEL);
					if (lResult == IDCANCEL)
					{
						goto UnpackEnd;
					}
					// We have to get past the compressed data to
					// the next file header.
					//...........................................
					uli.QuadPart = SetMyFilePointer((LPTSTR)&szFileName,hInputFile,
													 pfhdr.uliCompressedFileSize.QuadPart,
													 FILE_CURRENT);
					if (uli.QuadPart == -1)
					{
						goto UnpackEnd;
					}
					// Close and delete the output file we just created.
					//..................................................
					if (hOutPutFile)
					{
						bResult = CloseMyHandle((LPTSTR)&szDestination,hOutPutFile);
						if (!bResult)
						{
							goto UnpackEnd;
						}
						hOutPutFile = 0;

						bResult = DeleteMyFile((LPTSTR)&szDestination);
						if (!bResult)
						{
							goto UnpackEnd;
						}
					}
					bDiskError = FALSE;
					iNumberOfFiles--;
					continue;
				}
			}
			// Setup the name and icon of the file to decompress.
			//...................................................
			if (hIcon2)
			{
				DestroyIcon(hIcon2);
			}
			hIcon2 = hIcon;
			hIcon = 0;
			SendMessage(GetDlgItem(hDialogModeLess,IDC_ICON2),STM_SETICON,(WPARAM)hIcon2,0);

			SetDlgItemTextFmt(hDialogModeLess,IDC_FILE2,
							 (LPCTSTR)GetDisplayName(&shfi1,(LPCTSTR)&szDestination));

			EmptyTheMessageQue();

			if (bWeHaveLzw)
			{
				// Allocate the extended memory as required for each
				// file as it is to be unpacked.
				//..................................................
				SetLzwParameters((LPCODE_STATS)&CodeStats,pfhdr.LargestBitCode);
				lpCodeTable = AllocateMemory(dwCodeTableSize);
				lpPStack = AllocateMemory(dwPStackSize);
				if (!lpCodeTable || !lpPStack)
				{
					goto UnpackEnd;
				}
				// Decompress the file.
				//.....................
				bResult = DecompressTheFile((LPBYTE)&szFileName,hInputFile,
										   (LPBYTE)&szDestination,hOutPutFile);
				if (!bResult)
				{
					goto UnpackEnd;
				}
				// We are done with this file. Deallocate the memory
				// for the code and pseudo stack.
				//..................................................
				bResult = DeallocateMemory(lpCodeTable);
				if (!bResult)
				{
					goto UnpackEnd;
				}
				lpCodeTable = 0;
				bResult = DeallocateMemory(lpPStack);
				if (!bResult)
				{
					goto UnpackEnd;
				}
				lpPStack = 0;
			}
			else
			{
				// Decompress using the zip algorithms.
				//.....................................
				bResult = UnzipMyFile((LPBYTE)&szFileName,hInputFile,
										   (LPBYTE)&szDestination,hOutPutFile);
				if (!bResult)
				{
					goto UnpackEnd;
				}
			}
		}
		// Check the crc32 check value and close out the file after
		// adding the times and attributes.
		//.........................................................
		if (bWeHaveLzw)
		{
			dwCheckCrc32 ^= -1;
		}
		if (dwCheckCrc32 != pfhdr.dwFileCrc32)
		{
			SetLastError(IDS_DECOMPINTEGRITYFAILED);
			ErrorProcedure((LPTSTR)&szDestination,IDS_READ,MB_OK);
		}
		else
		{
			dwPassCrc32++;
		}
		bResult = SetFileTime(hOutPutFile,&pfhdr.ftCreation,
							  &pfhdr.ftAccessed,&pfhdr.ftLastWrite);
		if (!bResult)
		{
			ErrorProcedure((LPTSTR)&szDestination,IDS_SETFILETIME,MB_OK);
		}
		bResult = CloseMyHandle((LPTSTR)&szDestination,hOutPutFile);
		if (!bResult)
		{
			goto UnpackEnd;
		}
		hOutPutFile = 0;

		bResult = SetFileAttributes((LPCTSTR)&szDestination,pfhdr.dwFileAttributes);
		if (!bResult)
		{
			ErrorProcedure((LPTSTR)&szDestination,IDS_SETFILEATTR,MB_OK);
		}
		iFilesUnpacked++;

		// Print running stats.
		//.....................
		StringCbPrintf((LPTSTR)&szOutBuffer,sizeof(szOutBuffer),(LPCTSTR)&szResults,
						pfidhdr.iFilesInVault,dwPassCrc32,iFilesUnpacked);
		SetDlgItemText(hDialogModeLess,IDC_STATEMENT1,(LPCTSTR)&szOutBuffer);
		bDiskError = FALSE;
		iNumberOfFiles--;
	}

  FinalStats:

	// Return the final error status.
	//...............................
	bError = FALSE;

	// Print final stats.
	//...................
	StringCbPrintf((LPTSTR)&szOutBuffer,sizeof(szOutBuffer),(LPCTSTR)&szResults,
				    pfidhdr.iFilesInVault,dwPassCrc32,iFilesUnpacked);
	SetDlgItemText(hDialogModeLess,IDC_STATEMENT1,(LPCTSTR)&szOutBuffer);

	// Set the position of the progress bar to 100% if we did not quit
	// or exit with an error
	//................................................................
	if (iFilesUnpacked == pfidhdr.iFilesInVault)
	{
		SendMessage(GetDlgItem(hDialogModeLess,IDC_PROGRESS),PBM_SETPOS,(WPARAM)200,0);
	}
	// Make sure bCancelOperation is set to FALSE.
	//............................................
	bCancelOperation = FALSE;

	// Stop the avi clip.
	//...................
	if (bAviClipOK)
	{
		bAviClipOK = Animate_Stop(hAviClip);
	}
	// Change the cancel button to ok.
	//................................
	SetDlgItemText(hDialogModeLess,IDCANCEL,TEXT("&OK"));

	FlashMyIcon(TRUE);

	// Wait until we close the dialog box to exit.
	//............................................
	while(TRUE)
	{
		CheckForMessages();
		if (bCancelOperation == TRUE)
		{
			bCancelOperation = FALSE;
			break;
		}
	}

	UnpackEnd:

	FlashMyIcon(FALSE);

	Crc32Table(DELETE_TABLE);

	if (hIcon)
	{
		DestroyIcon(hIcon);
		hIcon = 0;
	}
	if (hIcon2)
	{
		DestroyIcon(hIcon2);
		hIcon2 = 0;
	}
	if (bAviClipOK)
	{
		Animate_Close(hAviClip);
	}
	if (hDialogModeLess)
	{
		DestroyWindow(hDialogModeLess);
	}
	if (lpInBuffer)
	{
		ZeroMemory(lpInBuffer,BUFFER_SIZE_IN);
		DeallocateMemory(lpInBuffer);
		lpInBuffer = 0;
	}
	if (lpOutBuffer)
	{
		ZeroMemory(lpOutBuffer,BUFFER_SIZE_OUT);
		DeallocateMemory(lpOutBuffer);
		lpOutBuffer = 0;
	}
	if (lpCodeTable)
	{
		DeallocateMemory(lpCodeTable);
		lpCodeTable = 0;
	}
	if (lpPStack)
	{
		DeallocateMemory(lpPStack);
		lpPStack = 0;
	}
	if (hInputFile)
	{
		CloseMyHandle((LPTSTR)&szFileName,hInputFile);
		hInputFile = 0;
	}
	if (bWipeAfterUnpacking && !bDiskError && !bError)
	{
		ConfirmWipeMyFile(IDS_CONFIRMUNPACK,(LPBYTE)&szFileName,TRUE);
	}
	if (hOutPutFile)
	{
		CloseMyHandle((LPTSTR)&szDestination,hOutPutFile);
		hOutPutFile = 0;
	}
	if (bDiskError)
	{
		DeleteMyFile((LPTSTR)&szDestination);
	}
	bCancelOperation = FALSE;
	if (!lpPkdFile)
	{
		bProcessInProgress = FALSE;
	}
	ChangeHelpTopic(dwOldHelpTopic);
	return(bError);
}

// Special hook for open file dialog for unpacking a file.
// Adds a wipe after unpacking checkbox.
//........................................................
UINT CALLBACK MyUnpackOFNHookProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	static HWND		hWndParent;
	UINT			uCheck;
	LPHELPINFO		lphi;

	switch (uiMsg)
	{
		case WM_INITDIALOG:
		{
			hWndParent = GetParent(hDlg);
			SetMyIcon(hWndParent);
			CenterWindow(hWndParent,hMainWindow);
			return(TRUE);
		}

		case WM_COMMAND:
		{
			switch(LOWORD(wParam))
			{
				case IDC_WIPEPACKEDFILE:
				{
					uCheck = IsDlgButtonChecked(hDlg,IDC_WIPEPACKEDFILE);
					if (uCheck == BST_CHECKED)
					{
						uCheck = BST_UNCHECKED;
						bWipeAfterUnpacking = FALSE;
					}
					else
					{
						uCheck = BST_CHECKED;
						bWipeAfterUnpacking = TRUE;
					}
					CheckDlgButton(hDlg,IDC_WIPEPACKEDFILE,uCheck);
				}
				break;
			}
		}
		break;

		case WM_HELP:
		{
			lphi = (LPHELPINFO)lParam;
			if (lphi->iContextType == HELPINFO_WINDOW)
			{
				if (lphi->iCtrlId == IDC_WIPEPACKEDFILE)
				{
					PopupHelp(hDlg,lParam);
					return(TRUE);
				}
			}
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;
	}
	return(FALSE);
}

// Pack one or more files.
//........................
BOOL PackFiles(LPBYTE lpBuffer, LPOPENFILENAME lpofn)
{
	OPENFILENAME				ofn;
	ULARGE_INTEGER				uliFileHeader;
	ULARGE_INTEGER				uli;
	ULARGE_INTEGER				uliScratch1;
	ULARGE_INTEGER				uliScratch2;
	BY_HANDLE_FILE_INFORMATION	fi;
	LPBYTE						lpTempFilePtr;
	LPBYTE						lpTransferFile;
	HANDLE						hTransferFile;
	DWORD						dwOldHelpTopic;
	DWORD						dwBytesWritten;
	DWORD						dwBytesToRead;
	DWORD						dwBytesRead;
	int							iFileNameLength;
	int							iResult;
	BOOL						bMoreThanOne;
	BOOL						bResult;
	BOOL						bDiskError;
	BOOL						bError;
	int							iTotalFiles;
	UINT						uiDriveType;
	HANDLE						hSearch;
	WIN32_FIND_DATA				wfd;
	TCHAR						szRoot[16];
	
	bProcessInProgress = TRUE;
	dwOldHelpTopic = ChangeHelpTopic(IDH_PACK);
	bAviClipOK = FALSE;
	bDiskError = FALSE;
	bError = TRUE;
	bWipeAfterPacking = FALSE;
	liSegment.QuadPart = 0;

	// If we are not calling from another procedure, we need a destination.
	//.....................................................................
	if (!lpBuffer)
	{
		bNeedDestination = TRUE;
	}
	// Clear the file header.
	//.......................
	ZeroMemory(&pfidhdr,sizeof(pfidhdr));
	if (bUseMd5)
	{
		CopyMemory(&pfidhdr.FileId,&PackedFileId,lstrlen((LPCTSTR)&PackedFileId));
	}
	else
	{
		CopyMemory(&pfidhdr.FileId,&PackedFileIdZ,lstrlen((LPCTSTR)&PackedFileIdZ));
	}
	if (BPC())
	{
		goto PackEnd;
	}
	// Initialize the OPENFILENAME structure.
	//.......................................
	InitializeOFN(&ofn,SAVE_SOURCE);

	// If we are not passing parameters in from another procedure we
	// have to get the list of files outselves.
	//..............................................................
	if (!lpBuffer)
	{
		// Allocate the memory for the return file buffer. This is
		// the maximum sized buffer that the GetOpenFileName common
		// dialog box procedure can handle.
		//.........................................................
		lpFileReturn1 = AllocateMemory((64 * 1024) - 1);
		if (!lpFileReturn1)
		{
			goto PackEnd;
		}
		// Initialize with specific information for this procedure.
		//.........................................................
		ofn.lpstrFile = lpFileReturn1;
		ofn.nMaxFile = ((64 * 1024) - 1);
		ofn.hwndOwner = hMainWindow;
		ofn.lpstrFilter = TEXT("All Files [*.*]\0*.*\0Tscg Files [.rng;.rsakey;.tsc;.otp;.pad;.tsig;.jrl]\0*.rng;*.rsakey;*.tsc;*.otp;*.pad;*.tsig;*.jrl\0Adobe PDF Files [.pdf]\0*.pdf\0Executable Files [.exe;.dll;.ocx]\0*.exe;*.dll;*.ocx\0Image Files [.bmp;.dib;.gif;.jpg;,ico;,cur]\0*.bmp;*.dib;*.gif;*.jpg;*.ico;*.cur\0Word Documents [.doc]\0*.doc\0Web Pages [.htm;.html;.mht]\0*.htm;*.html;*.mht\0Email Files [.eml]\0*.eml\0Rich Text Format [.rtf]\0*.rtf\0Text Files [.txt]\0*.txt\0Lotus 1-2-3 [.wk1;.wk3]\0*.wk1;*.wk3\0Microsoft Excel Worksheet [.xls;.xlw]\0*.xls;*.xlw\0Windows Write [.wri]\0*.wri\0WordPerfect 5.x [.doc]\0*.doc\0WordPerfect 6.x [.wpd;.doc]\0*.wpd;*.doc\0");
		ofn.nFilterIndex = 1;
		ofn.lpstrTitle = TEXT("Select One or More Files to Pack");
		ofn.Flags = (OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST |
					 OFN_ENABLEHOOK | OFN_ENABLESIZING | OFN_SHOWHELP | 
					 OFN_ALLOWMULTISELECT | OFN_HIDEREADONLY);
		ofn.lpstrDefExt = NULL;

		// Allow wipe original if no admin account or admin allows it.
		//............................................................
		if (!bAa || (bAa && (cfg.V1.dwV3 & PERMIT_WIPE_ORIGINAL)) || 
		   (bAa && !bRestrictionsInEffect))
		{
			if (bWin2000OrGreater)
			{
				ofn.lpTemplateName = TEXT("WIPEAFTERPACKINGNEW");
			}
			else
			{
				ofn.lpTemplateName = TEXT("WIPEAFTERPACKING");
			}
			ofn.lpfnHook = MyPackOFNHookProc;
			ofn.Flags |= OFN_ENABLETEMPLATE;
			ofn.hInstance = hInst;
		}
		else
		{
			ofn.lpfnHook = MyOFNHookProc;
		}
		// Setup the icon to use in the caption bar.
		//..........................................
		lpIconPointer = lpszAppName;

		// Select the files to pack.
		//..........................
		if (!GetOpenFileName(&ofn))
		{
			CommDlgBoxErrorProc(IDS_GET_FILES);
			goto PackEnd;
		}
	}
	else
	{
		// Setup the file names and ofn structure that we want to compress from
		// the other procedure.
		//.....................................................................
		lpFileReturn1 = lpBuffer;
		CopyMemory(&ofn,lpofn,sizeof(OPENFILENAME));
	}
	EmptyTheMessageQue();

	// Save a copy of the ofn structure.
	//..................................
	CopyMemory(&ofnPack,&ofn,sizeof(OPENFILENAME));

	// Determine the number of files we have to pack.
	// Used to setup the progress bar.
	//...............................................
	lpTempFilePtr = (lpFileReturn1 + ofn.nFileOffset);
	iNumberOfFiles = 0;
	while(TRUE)
	{
		if (*lpTempFilePtr == 0)
		{
			break;
		}
		iFileNameLength = lstrlen(lpTempFilePtr);
		iNumberOfFiles++;

		// Point to the next file selected. Get past the
		// trailing null byte.
		//..............................................
		lpTempFilePtr += (int)(iFileNameLength + 1);
	}
	// Setup the step increment for the progress bar.
	// Always equals one for this case.
	//...............................................
	iStepIncrement = 1;

	// Store the total number of files.
	//.................................
	iTotalFiles = iNumberOfFiles;

	// Setup the path for our selected files. If only 1 file
	// selected, we have the whole file spec.
	//......................................................
	ZeroMemory(&szFileName,sizeof(szFileName));
	StringCbCatEx((LPTSTR)&szFileName,sizeof(szFileName),lpFileReturn1,NULL,NULL,
				   dwStringSafeFlag);

	// Save the dir name.
	//...................
	if (iTotalFiles > 1)
	{
		SaveDirName((LPBYTE)&szFileName,SAVE_SOURCE,FALSE);
	}
	else
	{
		SaveDirName((LPBYTE)&szFileName,SAVE_SOURCE,TRUE);
	}
	// If we only have one file to compress, see if we are trying to
	// compress a file that is already compressed.
	//..............................................................
	if (iTotalFiles == 1 && lpBuffer)
	{
		bAlreadyPacked = IsFileAlreadyPacked(lpFileReturn1);
		
		if (bAlreadyPacked)
		{
			// We are called from another source. Put the already compressed
			// file name in the destination and set wipe original to false.
			//...............................................................
			CopyMemory(&szDestination,lpFileReturn1,MAX_PATH);

			// We have to get the size of the file to return to the encryption
			// process.
			//................................................................
			hOutPutFile = CreateMyFile((LPTSTR)&szDestination,GENERIC_READ |	
										GENERIC_WRITE,0,NULL,OPEN_EXISTING,	
										FILE_ATTRIBUTE_NORMAL,NULL);
			if (!hOutPutFile)
			{
				goto PackEnd;
			}
			liEncFileSize.QuadPart = GetMyFileSize((LPTSTR)&szDestination,hOutPutFile);
			if (liEncFileSize.QuadPart == -1)
			{
				goto PackEnd;
			}
			bResult = CloseMyHandle((LPTSTR)&szDestination,hOutPutFile);
				
			if (!bResult)
			{
				goto PackEnd;
			}
			hOutPutFile = 0;
			bIntermediatePkd = FALSE;
		}
	}
	// If we have more than one file we have to add a backslash.
	//.........................................................
	bMoreThanOne = FALSE;
	if (iNumberOfFiles > 1)
	{
		bMoreThanOne = TRUE;
		lpFileInsert = PathAddBackslash((LPTSTR)&szFileName);
	}
	lpTempFilePtr = (lpFileReturn1 + ofn.nFileOffset);

	// Determine the total size of all the selected files.
	//....................................................
	uliScratch1.QuadPart = 0;

	while(iNumberOfFiles > 0)
	{
		if (bMoreThanOne)
		{
			*lpFileInsert = 0;
			StringCbCatEx((LPTSTR)&szFileName,sizeof(szFileName),lpTempFilePtr,NULL,NULL,
						  dwStringSafeFlag);
			iFileNameLength = lstrlen(lpTempFilePtr);
			lpTempFilePtr += (int)(iFileNameLength + 1);
		}
		hSearch = FindFirstFile((LPCTSTR)&szFileName,&wfd);

		if (hSearch == INVALID_HANDLE_VALUE)
		{
			ErrorProcedure((LPTSTR)&szFileName,IDS_FINDFIRSTFILE,MB_OK);
			goto PackEnd;
		}
		FindClose(hSearch);
		uliScratch2.LowPart = wfd.nFileSizeLow;
		uliScratch2.HighPart = wfd.nFileSizeHigh;
		uliScratch1.QuadPart += uliScratch2.QuadPart;

		iNumberOfFiles--;
	}
	iNumberOfFiles = iTotalFiles;
	lpTempFilePtr = (lpFileReturn1 + ofn.nFileOffset);

	// If the total size of all the files selected is 0, we cannot pack them.
	//.......................................................................
	if (uliScratch1.QuadPart == 0)
	{
		SetLastError(IDS_TOTALEQUALSZERO);
		ErrorProcedure((LPTSTR)lpFileReturn1,IDS_FINDFIRSTFILE,MB_OK);
		goto PackEnd;
	}
	// Determine what is a half percent for updating the progress bar.
	//................................................................
	if (uliScratch1.QuadPart < 40000)
	{
		__asm
		{
			xor		edx,edx
			mov		eax,uliScratch1.LowPart
			mov		ecx,200
			div		ecx
			cmp		eax,edx
			jae		L1
			inc		eax
		L1:	mov		liHalfPercent.HighPart,0
			mov		liHalfPercent.LowPart,eax
		}
	}
	else
	{
		liHalfPercent.QuadPart = (uliScratch1.QuadPart / 200);
	
		if (liHalfPercent.QuadPart == 0)
		{
			liHalfPercent.QuadPart = 1;
		}
	}
	liHalfPercentDup.QuadPart = liHalfPercent.QuadPart;

	if (lpBuffer && bEncryptIt && bShowPreviousEncFolder)
	{
		InitializeOFN(&ofn,SAVE_ENCRYPT_DIR);
	}
	else
	{
		InitializeOFN(&ofn,SAVE_DESTINATION);
	}
	EmptyTheMessageQue();

	// If we need to select a name and destination for the packed file, do so.
	//........................................................................
	if (bNeedDestination)
	{
		if (lpBuffer && bEncryptIt && bShowPreviousEncFolder)
		{
			SetCurrentDirectory((LPCTSTR)&cfg.szPreviousEncFiles);
		}
		else
		{
			SetCurrentDirectory((LPCTSTR)&szPreviousDestinationDir);
		}
		ZeroMemory(&szDestination,MAX_PATH);

		// Initialize with specific information for our packed file.
		//..........................................................
		if (iNumberOfFiles == 1)
		{
			StringCbCatEx((LPTSTR)&szDestination,sizeof(szDestination),(LPCTSTR)lpTempFilePtr,
						   NULL,NULL,dwStringSafeFlag);
			PathRemoveExtension((LPTSTR)&szDestination);
		}
		ofn.lpstrFile = szDestination;
		ofn.nMaxFile = MAX_PATH;
		ofn.hwndOwner = hMainWindow;
		ofn.nFilterIndex = 1;
		
		// If we are calling from outside we are saving a packed and encrypted file.
		//..........................................................................
		if (lpBuffer && bEncryptIt)
		{
			ofn.lpstrFilter = TEXT("Tscg Encrypted Files [.tsc]\0*.tsc*\0All Files [*.*]\0*.*\0");

			if (bAlreadyPacked)
			{
				ofn.lpstrTitle = TEXT("Save Encrypted File As");
			}
			else
			{
				ofn.lpstrTitle = TEXT("Save Packed and Encrypted File As");
			}
		}
		else
		{
			ofn.lpstrFilter = TEXT("Packed Files [.pkd]\0*.pkd\0All Files [*.*]\0*.*\0");
			ofn.lpstrTitle = TEXT("Save Packed File As");
			bEncryptIt = TRUE;
		}
		ofn.Flags = (OFN_EXPLORER | OFN_PATHMUSTEXIST | OFN_ENABLEHOOK | OFN_ENABLESIZING | 
					 OFN_SHOWHELP | OFN_HIDEREADONLY);
		if (bAlreadyPacked)
		{
			ofn.lpstrDefExt = TEXT("tsc");
		}
		else
		{
			ofn.lpstrDefExt = TEXT("pkd");
		}
		ofn.lpfnHook = MyOFNHookProc;

		while(TRUE)
		{
			// Get the name and path we want to use for our packed file.
			//..........................................................
			if (!GetSaveFileName(&ofn))
			{
				CommDlgBoxErrorProc(IDS_SAVE_AS);
				goto PackEnd;
			}
			lpDestinationFileName = PathFindFileName((LPCTSTR)&szDestination);

			hSearch = FindFirstFile((LPCTSTR)&szDestination,&wfd);

			// Save the dir name.
			//...................
			if (bEncryptIt && bShowPreviousEncFolder)
			{
				SaveDirName((LPBYTE)&szDestination,SAVE_ENCRYPT_DIR | SAVE_DESTINATION,TRUE);
			}
			else
			{
				SaveDirName((LPBYTE)&szDestination,SAVE_DESTINATION,TRUE);
			}
			if (hSearch == INVALID_HANDLE_VALUE)
			{
				break;
			}
			EmptyTheMessageQue();

			ZeroMemory(&szDestination,MAX_PATH);

			// The file exists, warn the user so he can enter another
			// file name.
			//.......................................................
			FindClose(hSearch);
			SetLastError(IDS_ALREADYEXISTS);
			ErrorProcedure((LPTSTR)&szDestination,IDS_FINDFIRSTFILE,MB_OK);
		}
		if (bAlreadyPacked)
		{
			// Everything is OK.
			//..................
			bError = FALSE;
			goto PackEnd;
		}
	}
	// Create the packed file.
	//........................
	hOutPutFile = CreateMyFile((LPTSTR)&szDestination,GENERIC_READ |
								GENERIC_WRITE,0,NULL,CREATE_NEW,FILE_ATTRIBUTE_NORMAL,NULL);
	if (!hOutPutFile)
	{
		goto PackEnd;
	}
	bDiskError = TRUE;

	// Get the drive type for our avi file.
	//.....................................
	iWhichAviClip = FILE_COPY;
	ZeroMemory(&szRoot,sizeof(szRoot));
	CopyMemory(&szRoot,&szDestination,sizeof(szRoot));
	PathStripToRoot((LPTSTR)&szRoot);
	uiDriveType = GetDriveType((LPCTSTR)&szRoot);
	if (uiDriveType == DRIVE_REMOVABLE && (*szDestination == 0x41 ||
		*szDestination == 0x61 || *szDestination == 0x42 || *szDestination == 0x62))
	{
		iWhichAviClip = FILE_DISK;
	}
	else if (uiDriveType == DRIVE_CDROM)
	{
		iWhichAviClip = FILE_CDROM;
	}
	// Build the crc32 table.
	//.......................
	bResult = Crc32Table(BUILD_TABLE);
	if (!bResult)
	{
		goto PackEnd;
	}
	// Allocate memory for the input and output buffers. Output
	// buffer must be larger since it can grow to one or two
	// bytes larger than the input buffer.
	//.........................................................
	lpInBuffer = AllocateMemory(BUFFER_SIZE_IN);
	lpOutBuffer = AllocateMemory(BUFFER_SIZE_OUT);
	if (!lpInBuffer || !lpOutBuffer)
	{
		goto PackEnd;
	}
	bCancelOperation = FALSE;
	hDialogModeLess = CreateDialog(hInst,TEXT("PACKFILES"),hMainWindow,(DLGPROC)PackFilesProc);

	if (!hDialogModeLess)
	{
		ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
		goto PackEnd;
	}
	// Start the avi clip.
	//....................
	if (bAviClipOK)
	{
		bAviClipOK = Animate_Play(hAviClip,0,-1,-1);
	}
	// Setup some variables if we are using the old style algorithms.
	//...............................................................
	if (bUseMd5)
	{
		// Determine the final maximum code setting for the pack procedure.
		//.................................................................
		SetMaxCodeSizeOnStartUp();

		// If the maximum pack code size is 0 we do not have enough
		// memory to pack any of the files.
		//.........................................................
		if (iMaxPack < 14)
		{
			SetLastError(IDS_NOTENOUGHMEMORYTOPACKWITH);
			ErrorProcedure((LPTSTR)lpszNA,IDS_ALLOCATEMEMORY,MB_OK);
			goto PackEnd;
		}
		SetLzwParameters((LPCODE_STATS)&CodeStats,iMaxPack);

		// Allocate the memory for code and hash tables.
		//..............................................
		lpCodeTable = AllocateMemory(dwCodeTableSize);
		lpHashTable = AllocateMemory(dwHashTableSize);
		if (!lpCodeTable || !lpHashTable)
		{
			goto PackEnd;
		}
	}
	// Setup some variables.
	//......................
	uliTotalCodes.QuadPart  = 0;
	uliInCount.QuadPart = 0;
	uliFileCodes.QuadPart = 0;

	// Write the file id header to the start of the compressed file.
	//..............................................................
	bResult = WriteMyFile((LPTSTR)&szDestination,hOutPutFile,&pfidhdr,
						   sizeof(PACKED_FILE_ID_HDR),&dwBytesWritten,NULL);
	if (!bResult)
	{
		goto PackEnd;
	}
	uliOutCount.QuadPart = sizeof(PACKED_FILE_ID_HDR);

	// While we have files left to pack.
	//..................................
	while(iNumberOfFiles > 0)
	{
		EmptyTheMessageQue();
		if (bCancelOperation == TRUE)
		{
			goto PackEnd;
		}
		// Setup our file name in the dialog box and file spec.
		// If we have more than one file we have to append the
		// file name to the path.
		//.....................................................
		if (bMoreThanOne)
		{
			*lpFileInsert = 0;
			StringCbCatEx((LPTSTR)&szFileName,sizeof(szFileName),lpTempFilePtr,NULL,NULL,
						   dwStringSafeFlag);

			// Get the file name length into the header.
			//..........................................
			pfhdr.wLengthOfFileName = lstrlen(lpTempFilePtr);

			// Point to the next file selected. Get past the
			// trailing null byte.
			//..............................................
			lpTempFilePtr += (pfhdr.wLengthOfFileName + 1);
		}
		// Get pointers to the file name and extension.
		//.............................................
		lpFileName = PathFindFileName((LPCTSTR)&szFileName);
		lpFileExtension = PathFindExtension((LPCTSTR)&szFileName);

		// Setup the file name and icon in the dialog box.
		//................................................
		SetDlgItemTextFmt(hDialogModeLess,IDC_FILE2,
						 (LPCTSTR)GetDisplayName(&shfi1,(LPCTSTR)&szFileName));

		if (hIcon)
		{
			DestroyIcon(hIcon);
			hIcon = 0;
		}
		hIcon = FindMyIcon((LPBYTE)&szFileName,lpFileExtension);

		// If we did not find one, use the default.
		//.........................................
		if (!hIcon)
		{
			hIcon = LoadImage(hInst,"I_FACEFROWN",IMAGE_ICON,32,32,LR_SHARED);
		}
		if (hIcon)
		{
			SendMessage(GetDlgItem(hDialogModeLess,IDC_ICON2),STM_SETICON,(WPARAM)hIcon,0);
		}
		hInputFile = CreateMyFile((LPTSTR)&szFileName,GENERIC_READ,0,
								  NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
		if (!hInputFile)
		{
			goto PackEnd;
		}
		if (bUseMd5)
		{
			// Open a temporary file to hold the output of the compressor
			// until it can be determined if the file compressed or not.	
			//...........................................................
			hBackUpFile = CreateMyFile((LPTSTR)&szBackUpFile,GENERIC_READ | GENERIC_WRITE,0,
										NULL,CREATE_NEW,FILE_ATTRIBUTE_NORMAL,NULL);
			if (!hBackUpFile)
			{
				goto PackEnd;
			}
		}
		EmptyTheMessageQue();
		if (bCancelOperation == TRUE)
		{
			goto PackEnd;
		}		
		// Clear the file info header.
		//............................
		ZeroMemory(&pfhdr,sizeof(PACKED_FILE_HEADER));

		// Get the information on the file to see if we want to
		// pack it. If it is 0 length we skip it.
		//......................................................
		bResult = GetFileInformationByHandle(hInputFile,&fi);
		if (!bResult)
		{
			ErrorProcedure((LPTSTR)&szFileName,IDS_GETFILEINFO,MB_OK);
			goto PackEnd;
		}
		if (fi.nFileSizeLow == 0 && fi.nFileSizeHigh == 0)
		{
			bResult = CloseMyHandle((LPTSTR)&szFileName,hInputFile);
			if (!bResult)
			{
				goto PackEnd;
			}
			hInputFile = 0;
			if (bUseMd5)
			{
				bResult = CloseMyHandle((LPTSTR)&szBackUpFile,hBackUpFile);
				if (!bResult)
				{
					goto PackEnd;
				}
				hBackUpFile = 0;
				bResult = DeleteMyFile((LPTSTR)&szBackUpFile);
				if (!bResult)
				{
					goto PackEnd;
				}
			}
			iNumberOfFiles--;
			continue;
		}
		EmptyTheMessageQue();
		if (bCancelOperation == TRUE)
		{
			goto PackEnd;
		}		
		uli.LowPart = fi.nFileSizeLow;
		uli.HighPart = fi.nFileSizeHigh;
		pfidhdr.uliTotalSizeOfFiles.QuadPart += uli.QuadPart;
		pfidhdr.iFilesInVault++;
		pfhdr.dwFileAttributes = fi.dwFileAttributes;
		pfhdr.ftAccessed = fi.ftLastAccessTime;
		pfhdr.ftCreation = fi.ftCreationTime;
		pfhdr.ftLastWrite = fi.ftLastWriteTime;
		pfhdr.uliFileSize.QuadPart = uli.QuadPart;
		if (bUseMd5)
		{
			pfhdr.LargestBitCode = LOBYTE(LOWORD(iMaxPack));
		}
		else
		{
			pfhdr.LargestBitCode = Z_BEST_COMPRESSION;
		}
		pfhdr.wLengthOfFileName = lstrlen((LPCTSTR)lpFileName);

		// Save a pointer to the file header so we can write the
		// final header after the file is compressed.
		//......................................................
		uliFileHeader.QuadPart = 0;
		uliFileHeader.QuadPart = SetMyFilePointer((LPTSTR)&szDestination,hOutPutFile,
												   uliFileHeader.QuadPart,FILE_END);
		if (uliFileHeader.QuadPart == -1)
		{
			goto PackEnd;
		}
		// Write a preliminary file header for the file we are packing.
		//.............................................................
		bResult = WriteMyFile((LPTSTR)&szDestination,hOutPutFile,
							   &pfhdr,sizeof(PACKED_FILE_HEADER),&dwBytesWritten,NULL);
		if (!bResult)
		{
			goto PackEnd;
		}
		uliOutCount.QuadPart += sizeof(PACKED_FILE_HEADER);

		// Now write the file name.
		//.........................
		bResult = WriteMyFile((LPTSTR)&szDestination,hOutPutFile,
							   lpFileName,lstrlen(lpFileName),&dwBytesWritten,NULL);
		if (!bResult)
		{
			goto PackEnd;
		}
		uliOutCount.QuadPart += lstrlen(lpFileName);

		if (bUseMd5)
		{
			// Compress the file with the old LZW algorithms.
			//...............................................
			bResult = CompressMyFile((LPBYTE)&szBackUpFile,hBackUpFile,(LPBYTE)&szFileName,
									  hInputFile);
			if (!bResult)
			{
				goto PackEnd;
			}
			// Finalize the crc32 value for the file in the header.
			//.....................................................
			pfhdr.dwFileCrc32 ^= -1;

			// Determine if the file compressed ok or not.
			// If not, adjust some values.
			//............................................
			if (uliFileOut.QuadPart > uliFileIn.QuadPart)
			{
				pfhdr.LargestBitCode = 0;
				uliTotalCodes.QuadPart -= uliFileCodes.QuadPart;
				uliFileCodes.QuadPart = 0;
				pfhdr.uliCompressedFileSize.QuadPart = pfhdr.uliFileSize.QuadPart;
				uliTotalCodes.QuadPart += pfhdr.uliFileSize.QuadPart;
				uliOutCount.QuadPart += pfhdr.uliFileSize.QuadPart;
				uliOutCount.QuadPart -= uliFileOut.QuadPart;
				lpTransferFile = szFileName;
				hTransferFile = hInputFile;
			}
			else
			{
				lpTransferFile = szBackUpFile;
				hTransferFile = hBackUpFile;
			}
			// Transfer the temporary file, or packed file as the case
			// may be, to the compressed file. First rewind the file to
			// transfer.
			//.........................................................
			uli.QuadPart = 0;
			uli.QuadPart = SetMyFilePointer((LPTSTR)lpTransferFile,hTransferFile,uli.QuadPart,
											 FILE_BEGIN);
			if (uli.QuadPart == -1)
			{
				goto PackEnd;
			}
			uli.QuadPart = pfhdr.uliCompressedFileSize.QuadPart;

			while(uli.QuadPart > 0)
			{
				if (uli.QuadPart > BUFFER_SIZE_IN)
				{
					dwBytesToRead = BUFFER_SIZE_IN;
					uli.QuadPart -= BUFFER_SIZE_IN;
				}
				else
				{
					dwBytesToRead = uli.LowPart;
					uli.QuadPart = 0;
				}
				bResult = ReadMyFile((LPTSTR)lpTransferFile,hTransferFile,
									  lpInBuffer,dwBytesToRead,&dwBytesRead,NULL);
				if (!bResult)
				{
					goto PackEnd;
				}
				bResult = WriteMyFile((LPTSTR)&szDestination,hOutPutFile,
									   lpInBuffer,dwBytesRead,&dwBytesWritten,NULL);
				if (!bResult)
				{
					goto PackEnd;
				}
			}
		}
		else
		{
			// We are compressing using the zip algorithms.
			//.............................................
			bResult = ZipMyFile((LPBYTE)&szDestination,hOutPutFile,(LPBYTE)&szFileName,
							     hInputFile);
			if (!bResult)
			{
				goto PackEnd;
			}
		}
		// Calculate the header crc32 value for the file and write
		// the whole header to disk again.
		//...............................................
		CalculateHeaderCrc();
		uliFileHeader.QuadPart = SetMyFilePointer((LPTSTR)&szDestination,hOutPutFile,
												   uliFileHeader.QuadPart,FILE_BEGIN);
		if (uliFileHeader.QuadPart == -1)
		{
			goto PackEnd;
		}
		bResult = WriteMyFile((LPTSTR)&szDestination,hOutPutFile,
							   &pfhdr,sizeof(PACKED_FILE_HEADER),&dwBytesWritten,NULL);
		if (!bResult)
		{
			goto PackEnd;
		}
		if (bUseMd5)
		{
			// Close, wipe, and delete the temporary backup file.
			//...................................................
			bResult = CloseMyHandle((LPTSTR)&szBackUpFile,hBackUpFile);
			if (!bResult)
			{
				goto PackEnd;
			}
			hBackUpFile = 0;

			bResult = WipeMyFile((LPBYTE)&szBackUpFile,FALSE);
			if (bResult)
			{
				goto PackEnd;
			}
		}
		// Close the file we just packed.
		//...............................
		bResult = CloseMyHandle((LPTSTR)&szFileName,hInputFile);
		if (!bResult)
		{
			goto PackEnd;
		}
		hInputFile = 0;

		// If we have an icon open, delete it, but only if we have
		// more files to pack.
		//........................................................
		if (hIcon && iNumberOfFiles > 1)
		{
			DestroyIcon(hIcon);
			hIcon = 0;
		}
		iNumberOfFiles--;
	}
	// Check to make sure we actually packed some files.
	//..................................................
	if (pfidhdr.iFilesInVault == 0)
	{
		SetLastError(IDS_NOFILESPACKED);
		ErrorProcedure((LPTSTR)lpszNA,IDS_GETFILESIZE,MB_OK);
		goto PackEnd;
	}
	// Write the final file header to disk.
	//.....................................
	uli.QuadPart = 0;
	uli.QuadPart = SetMyFilePointer((LPTSTR)&szDestination,hOutPutFile,uli.QuadPart,
									 FILE_BEGIN);
	if (uli.QuadPart == -1)
	{
		goto PackEnd;
	}
	bResult = WriteMyFile((LPTSTR)&szDestination,hOutPutFile,&pfidhdr,
						   sizeof(PACKED_FILE_ID_HDR),&dwBytesWritten,NULL);
	if (!bResult)
	{
		goto PackEnd;
	}
	// Get the final file size of the packed file.
	//............................................
	uliFinalFileSize.QuadPart = 0;
	uliFinalFileSize.QuadPart = SetMyFilePointer((LPTSTR)&szDestination,hOutPutFile,
												  uliFinalFileSize.QuadPart,FILE_END);
	if (uliFinalFileSize.QuadPart == -1)
	{
		goto PackEnd;
	}
	bResult = CloseMyHandle((LPTSTR)&szDestination,hOutPutFile);
	if (!bResult)
	{
		goto PackEnd;
	}
	hOutPutFile = 0;
	bDiskError = FALSE;
	bError = FALSE;

	// Setup the size of the file to encipher, if we are enciphering it.
	//..................................................................
	liEncFileSize.QuadPart = uliFinalFileSize.QuadPart;

	// Set the position of the progress bar to 100% if we did not quit
	// or exit with an error
	//................................................................
	if (!bCancelOperation)
	{
		SendMessage(GetDlgItem(hDialogModeLess,IDC_PROGRESS),PBM_SETPOS,(WPARAM)200,0);
	}
	// Make sure bCancelOperation is set to FALSE.
	//............................................
	bCancelOperation = FALSE;

	// Stop the avi clip.
	//...................
	if (bAviClipOK)
	{
		bAviClipOK = Animate_Stop(hAviClip);
	}
	// Change the cancel button to ok.
	//................................
	SetDlgItemText(hDialogModeLess,IDCANCEL,TEXT("&OK"));

	FlashMyIcon(TRUE);

	// Wait until we close the dialog box to exit.
	//............................................
	while(TRUE)
	{
		CheckForMessages();
		if (bCancelOperation == TRUE)
		{
			break;
		}
	}

	PackEnd:

	FlashMyIcon(FALSE);

	if (hIcon)
	{
		DestroyIcon(hIcon);
		hIcon = 0;
	}
	if (bAviClipOK)
	{
		Animate_Close(hAviClip);
	}
	if (hDialogModeLess)
	{
		DestroyWindow(hDialogModeLess);
	}
	if (lpInBuffer)
	{
		ZeroMemory(lpInBuffer,BUFFER_SIZE_IN);
		DeallocateMemory(lpInBuffer);
		lpInBuffer = 0;
	}
	if (lpOutBuffer)
	{
		ZeroMemory(lpOutBuffer,BUFFER_SIZE_OUT);
		DeallocateMemory(lpOutBuffer);
		lpOutBuffer = 0;
	}
	if (lpCodeTable)
	{
		ZeroMemory(lpCodeTable,dwCodeTableSize);
		DeallocateMemory(lpCodeTable);
		lpCodeTable = 0;
	}
	if (lpHashTable)
	{
		ZeroMemory(lpHashTable,dwHashTableSize);
		DeallocateMemory(lpHashTable);
		lpHashTable = 0;
	}
	Crc32Table(DELETE_TABLE);

	if (hOutPutFile)
	{
		CloseMyHandle((LPTSTR)&szDestination,hOutPutFile);
		hOutPutFile = 0;
	}
	if (bDiskError)
	{
		DeleteMyFile((LPTSTR)&szDestination);
	}
	if (hInputFile)
	{
		CloseMyHandle((LPTSTR)&szFileName,hInputFile);
		hInputFile = 0;
	}
	if (hBackUpFile)
	{
		CloseMyHandle((LPTSTR)&szBackUpFile,hBackUpFile);
		WipeMyFile((LPTSTR)&szBackUpFile,FALSE);
		hBackUpFile = 0;
	}
	// Show the final status of the packed files.
	//...........................................
	if (pfidhdr.iFilesInVault > 0 && !bDiskError && !bError)
	{
		iResult = DialogBox(hInst,TEXT("PACKEDFILESTATUS"),hMainWindow,
						   (DLGPROC)PackedFileStatusProc);

		// See if we had a system error in creating the dialog box.
		//.........................................................
		if (iResult == -1)
		{
			ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
		}
		// See if we want to wipe the files we just packed.
		//.................................................
		if (bWipeAfterPacking && iResult != -1 && !lpBuffer)
		{
			bWipeFiles = TRUE;
			bCancelOperation = FALSE;
			DeleteWipeFiles(lpFileReturn1,&ofnPack);
		}
	}
	if (!lpBuffer && lpFileReturn1)
	{
		ZeroMemory(lpFileReturn1,((64*1024)-1));
		DeallocateMemory(lpFileReturn1);
	}
	bCancelOperation = FALSE;
	bNeedDestination = FALSE;
	ChangeHelpTopic(dwOldHelpTopic);
	if (!lpBuffer)
	{
		bProcessInProgress = FALSE;
	}
	return(bError);
}

// Special hook for open file dialog for packing files.
// Adds a wipe after packing checkbox.
//.....................................................
UINT CALLBACK MyPackOFNHookProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	static HWND		hWndParent;
	UINT			uCheck;
	LPHELPINFO		lphi;

	switch (uiMsg)
	{
		case WM_INITDIALOG:
		{
			hWndParent = GetParent(hDlg);
			SetMyIcon(hWndParent);
			CenterWindow(hWndParent,hMainWindow);
			return(TRUE);
		}

		case WM_COMMAND:
		{
			switch(LOWORD(wParam))
			{
				case IDC_WIPEAFTERPACK:
				{
					uCheck = IsDlgButtonChecked(hDlg,IDC_WIPEAFTERPACK);
					if (uCheck == BST_CHECKED)
					{
						uCheck = BST_UNCHECKED;
						bWipeAfterPacking = FALSE;
					}
					else
					{
						uCheck = BST_CHECKED;
						bWipeAfterPacking = TRUE;
					}
					CheckDlgButton(hDlg,IDC_WIPEAFTERPACK,uCheck);
				}
				break;
			}
		}
		break;

		case WM_HELP:
		{
			lphi = (LPHELPINFO)lParam;
			if (lphi->iContextType == HELPINFO_WINDOW)
			{
				if (lphi->iCtrlId == IDC_WIPEAFTERPACK)
				{
					PopupHelp(hDlg,lParam);
					return(TRUE);
				}
			}
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;
	}
	return(FALSE);
}

// Set the maximum code size that the pack file procedure can use.
//................................................................
VOID SetTheMaximumCodeSize()
{
	int			iResult;
	DWORD		dwOldHelpTopic;

	bProcessInProgress = TRUE;
	dwOldHelpTopic = ChangeHelpTopic(IDH_SETMAXCODE);

	iResult = DialogBox(hInst,TEXT("SETMAXIMUMCODESIZE"),hMainWindow,
					   (DLGPROC)SetMaximumCodeSizeProc);

		// See if we had a system error in creating the dialog box.
	//.........................................................
	if (iResult == -1)
	{
		ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
	}
	bProcessInProgress = FALSE;
	ChangeHelpTopic(dwOldHelpTopic);
}

// CALLBACK procedure for packing files.
//......................................
LRESULT CALLBACK PackFilesProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);

			// Open the avi clip and display its first frame
			// in the animation control.
			//..............................................
			hAviClip = GetDlgItem(hDlg,IDC_ANIMATE);
			bAviClipOK = Animate_Open(hAviClip,(LPSTR)iWhichAviClip);

			// Setup the range and step increment for the progress bar.
			//.........................................................
			SendMessage(GetDlgItem(hDlg,IDC_PROGRESS),PBM_SETRANGE32,0,(LPARAM)200);
			SendMessage(GetDlgItem(hDlg,IDC_PROGRESS),PBM_SETSTEP,(WPARAM)iStepIncrement,0);

			// Setup the name of the packed file.
			//...................................
			SetDlgItemTextFmt(hDlg,IDC_FILE1,(LPCTSTR)GetDisplayName(&shfi1,
						     (LPCTSTR)&szDestination));

			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			SetFocus(GetDlgItem(hDlg,IDCANCEL));
			return(FALSE);
		}

		case WM_ACTIVATE:
		{
			if (wParam == 0)
			{
				hDlgCurrent = NULL;
			}
			else
			{
				hDlgCurrent = hDlg;
			}
			return(FALSE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				// Inform the procedure that we want to quit.
				//...........................................
				case IDCANCEL:
				{
					bCancelOperation = TRUE;
				}
				break;
			}
		}
		break;

		case WM_DESTROY:
		{
			hDialogModeLess = NULL;
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// CALLBACK procedure for unpacking files.
//........................................
LRESULT CALLBACK UnpackFilesProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);

			SetBoldFont(hDlg,IDC_STATEMENT1,0);

			// Open the avi clip and display its first frame
			// in the animation control.
			//..............................................
			hAviClip = GetDlgItem(hDlg,IDC_ANIMATE);
			bAviClipOK = Animate_Open(hAviClip,(LPSTR)iWhichAviClip);

			// Setup the range and step increment for the progress bar.
			//.........................................................
			SendMessage(GetDlgItem(hDlg,IDC_PROGRESS),PBM_SETRANGE32,0,(LPARAM)200);
			SendMessage(GetDlgItem(hDlg,IDC_PROGRESS),PBM_SETSTEP,(WPARAM)iStepIncrement,0);

			// Setup the name of the file to unpack.
			//...................................
			SetDlgItemTextFmt(hDlg,IDC_FILE1,(LPCTSTR)GetDisplayName(&shfi1,
							 (LPCTSTR)&szFileName));

			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			SetFocus(GetDlgItem(hDlg,IDCANCEL));
			return(FALSE);
		}

		case WM_ACTIVATE:
		{
			if (wParam == 0)
			{
				hDlgCurrent = NULL;
			}
			else
			{
				hDlgCurrent = hDlg;
			}
			return(FALSE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				// Inform the procedure that we want to quit.
				//...........................................
				case IDCANCEL:
				{
					bCancelOperation = TRUE;
				}
				break;
			}
		}
		break;

		case WM_DESTROY:
		{
			if (hDlgFont)
			{
				DeleteObject(hDlgFont);
				hDlgFont = 0;
			}
			hDialogModeLess = NULL;
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// CALLBACK procedure for displaying the final packed file status.
//................................................................
LRESULT CALLBACK PackedFileStatusProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			ULARGE_INTEGER		uliScratch;
			TCHAR				szOutBuffer[80];
			TCHAR				szInBuffer[80];

			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);

			// Setup the name of the packed file.
			//...................................
			SetDlgItemTextFmt(hDlg,IDC_CONTAINS,
							 (LPCTSTR)GetDisplayName(&shfi1,(LPCTSTR)&szDestination));

			// Display the final figures. Total number of files
			// packed first.
			//.................................................
			StringCbPrintf((LPTSTR)&szInBuffer,sizeof(szInBuffer),TEXT("%u"),
							pfidhdr.iFilesInVault);
			GetNumberFormat(LOCALE_USER_DEFAULT,0,(LPCTSTR)&szInBuffer,
						    &nFormatInfo,(LPTSTR)&szOutBuffer,sizeof(szOutBuffer));
			SetDlgItemText(hDlg,IDC_PACKEDFILES,(LPCTSTR)&szOutBuffer);

			// Percent compression.
			//.....................
			if (uliFinalFileSize.QuadPart < 
				pfidhdr.uliTotalSizeOfFiles.QuadPart)
			{
				uliScratch.QuadPart = (uliFinalFileSize.QuadPart * 100) /
									   pfidhdr.uliTotalSizeOfFiles.QuadPart;
				__asm
				{
					mov		eax,uliScratch.LowPart
					neg		eax
					add		eax,100
					mov		uliScratch.LowPart,eax
				}
			}
			else
			{
				uliScratch.QuadPart = 0;
			}
			_ui64toa(uliScratch.QuadPart,(LPBYTE)&szInBuffer,10);
			GetNumberFormat(LOCALE_USER_DEFAULT,0,(LPCTSTR)&szInBuffer,
						    &nFormatInfo,(LPTSTR)&szOutBuffer,sizeof(szOutBuffer));
			SetDlgItemText(hDlg,IDC_COMPRESSION,(LPCTSTR)&szOutBuffer);

			// Do bytes saved.
			//................
			if (uliFinalFileSize.QuadPart < 
				pfidhdr.uliTotalSizeOfFiles.QuadPart)
			{
				uliScratch.QuadPart = (pfidhdr.uliTotalSizeOfFiles.QuadPart -
									   uliFinalFileSize.QuadPart);
			}
			else
			{
				uliScratch.QuadPart = 0;
			}
			_ui64toa(uliScratch.QuadPart,(LPBYTE)&szInBuffer,10);
			GetNumberFormat(LOCALE_USER_DEFAULT,0,(LPCTSTR)&szInBuffer,
						    &nFormatInfo,(LPTSTR)&szOutBuffer,sizeof(szOutBuffer));
			SetDlgItemText(hDlg,IDC_BYTESSAVED,(LPCTSTR)&szOutBuffer);

			// Do original size.
			//..................
			_ui64toa(pfidhdr.uliTotalSizeOfFiles.QuadPart,
					(LPBYTE)&szInBuffer,10);
			GetNumberFormat(LOCALE_USER_DEFAULT,0,(LPCTSTR)&szInBuffer,
						    &nFormatInfo,(LPTSTR)&szOutBuffer,sizeof(szOutBuffer));
			SetDlgItemText(hDlg,IDC_ORIGINALSIZE,(LPCTSTR)&szOutBuffer);

			// Do packed size.
			//................
			_ui64toa(uliFinalFileSize.QuadPart,(LPBYTE)&szInBuffer,10);
			GetNumberFormat(LOCALE_USER_DEFAULT,0,(LPCTSTR)&szInBuffer,
						    &nFormatInfo,(LPTSTR)&szOutBuffer,sizeof(szOutBuffer));
			SetDlgItemText(hDlg,IDC_PACKEDSIZE,(LPCTSTR)&szOutBuffer);

			// Center the window.
			//...................
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			return(TRUE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDOK:
				{
					EndDialog(hDlg,IDOK);
				}
				break;

				case IDCANCEL:
				{
					EndDialog(hDlg,IDCANCEL);
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
			break;
		}

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// Set the maximum possible code size to use for compressing
// and decompressing on start up.
//..........................................................
VOID SetMaxCodeSizeOnStartUp()
{
	int			i;
	TCHAR		szOutBuffer[128];

	iRealMaxPack = 0;
	iMaxUnpack = 0;

	GlobalMemoryStatus(&mst);

	for (i = 0; i < NUMBER_OF_CODE_STATS; i++)
	{
		if (mst.dwAvailPhys >= CodeStats[i].PACK_MEM)
		{
			iRealMaxPack = CodeStats[i].BITS;
		}
		if (mst.dwAvailPhys >= CodeStats[i].UNPACK_MEM)
		{
			iMaxUnpack = CodeStats[i].BITS;
		}
	}
	iMaxPack = iRealMaxPack;

	// If we have set a max code size, make sure it stays
	// in effect.
	//...................................................
	if (cfg.iLastSetSize)
	{
		iMaxPack = cfg.iLastSetSize;
	}
	// If we have changed iMaxPack to a lower number to accomodate
	// a recipient, leave it alone. If is is greater than what we
	// can actually use, set it to dwRealMaxPack.
	//............................................................
	if (iMaxPack > iRealMaxPack)
	{
		iMaxPack = iRealMaxPack;
	}
	// If iRealMaxPack is 0 set iMaxPack to 0.
	//........................................
	if (iRealMaxPack == 0)
	{
		iMaxPack = 0;
	}
	if (bUseMd5)
	{
		StringCbPrintf((LPTSTR)&szOutBuffer,sizeof(szOutBuffer),(LPCTSTR)&szPackCode,
					    iMaxPack,iMaxUnpack);
	}
	else
	{
		CopyMemory(&szOutBuffer,&szLevel,sizeof(szLevel));
	}
	SendMessage(hStatusBar,SB_SETTEXT,1 | SBT_POPOUT,(LPARAM)szOutBuffer);
}

// CALLBACK procedure for setting the maximum code size to use
// while packing a file.
//............................................................
LRESULT CALLBACK SetMaximumCodeSizeProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			int			iControl;
			int			i;
			int			iBits;

			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);

			// Reset the maximum code size we can use.
			//........................................
			SetMaxCodeSizeOnStartUp();

			// Gray the radiobuttons that are out of range.
			//.............................................
			iControl = IDC_14BITS;
			iBits = FIRST_CODE_STAT;

			for (i = 0; i < NUMBER_OF_CODE_STATS; i++)
			{
				if (iRealMaxPack < iBits)
				{
					EnableWindow(GetDlgItem(hDlg,iControl),FALSE);
				}
				iControl++;
				iBits++;
			}
			// Set the default radiobutton.
			//.............................
			if (cfg.iLastSetSize == 0)
			{
				cfg.iLastSetSize = iRealMaxPack;
			}
			iSetBitSizeTo = cfg.iLastSetSize;
			iControl = (cfg.iLastSetSize - FIRST_CODE_STAT) + IDC_14BITS;
			CheckRadioButton(hDlg,IDC_14BITS,IDC_24BITS,iControl);

			// Center the window.
			//...................
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			return(TRUE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDC_14BITS:
				{
					CheckRadioButton(hDlg,IDC_14BITS,IDC_24BITS,IDC_14BITS);
					iSetBitSizeTo = 14;
				}
				break;

				case IDC_15BITS:
				{
					CheckRadioButton(hDlg,IDC_14BITS,IDC_24BITS,IDC_15BITS);
					iSetBitSizeTo = 15;
				}
				break;

				case IDC_16BITS:
				{
					CheckRadioButton(hDlg,IDC_14BITS,IDC_24BITS,IDC_16BITS);
					iSetBitSizeTo = 16;
				}
				break;

				case IDC_17BITS:
				{
					CheckRadioButton(hDlg,IDC_14BITS,IDC_24BITS,IDC_17BITS);
					iSetBitSizeTo = 17;
				}
				break;

				case IDC_18BITS:
				{
					CheckRadioButton(hDlg,IDC_14BITS,IDC_24BITS,IDC_18BITS);
					iSetBitSizeTo = 18;
				}
				break;

				case IDC_19BITS:
				{
					CheckRadioButton(hDlg,IDC_14BITS,IDC_24BITS,IDC_19BITS);
					iSetBitSizeTo = 19;
				}
				break;

				case IDC_20BITS:
				{
					CheckRadioButton(hDlg,IDC_14BITS,IDC_24BITS,IDC_20BITS);
					iSetBitSizeTo = 20;
				}
				break;

				case IDC_21BITS:
				{
					CheckRadioButton(hDlg,IDC_14BITS,IDC_24BITS,IDC_21BITS);
					iSetBitSizeTo = 21;
				}
				break;

				case IDC_22BITS:
				{
					CheckRadioButton(hDlg,IDC_14BITS,IDC_24BITS,IDC_22BITS);
					iSetBitSizeTo = 22;
				}
				break;

				case IDC_23BITS:
				{
					CheckRadioButton(hDlg,IDC_14BITS,IDC_24BITS,IDC_23BITS);
					iSetBitSizeTo = 23;
				}
				break;

				case IDC_24BITS:
				{
					CheckRadioButton(hDlg,IDC_14BITS,IDC_24BITS,IDC_24BITS);
					iSetBitSizeTo = 24;
				}
				break;

				case IDOK:
				{
					cfg.iLastSetSize = iSetBitSizeTo;
					SetMaxCodeSizeOnStartUp();
					EndDialog(hDlg,IDOK);
				}
				break;

				case IDCANCEL:
				{
					SetMaxCodeSizeOnStartUp();
					EndDialog(hDlg,IDCANCEL);
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
			break;
		}

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// Set up the parameters for the lzw compressor/decompressor.
//...........................................................
VOID SetLzwParameters(LPCODE_STATS lpCodeStats, int iIndex)
{
	int			iScratch;

	iIndex -= FIRST_CODE_STAT;

	iScratch = iIndex * sizeof(CODE_STATS);
	__asm
	{
		mov		eax,iScratch
		add		lpCodeStats,eax
	}

	dwMaxCode = lpCodeStats->MAX_C;
	dwResetCode = (dwMaxCode - 1);
	dwCodeTableSize = lpCodeStats->CT_SIZE;
	dwHashTableSize = lpCodeStats->HT_SIZE;
	dwHashTableEntries = (dwHashTableSize >> 2);
	dwPStackSize = lpCodeStats->PS_SIZE;
}

// Compress a file. Returns false for i/o errors.
//...............................................
BOOL CompressMyFile(LPBYTE lpOutFile, HANDLE hOutFile, LPBYTE lpInFile, HANDLE hInFile)
{
	BOOL		bResult = FALSE;
	DWORD		dwTheNextByte;
	DWORD		dwLzwCode;

	// Setup the character shift value for hashing the old code
	// and the character.
	//.........................................................
	CharacterShiftValue = (pfhdr.LargestBitCode - 8);

	// Initialize a few variables.
	//............................
	uliFileIn.QuadPart = 0;
	uliFileOut.QuadPart = 0;
	uliFileCodes.QuadPart = 0;
	dwCodeHoldArea = 0;
	iBitsLeft = 0;
	dwBitsInCode = DEFAULT_BITS;
	dwCurrentLevel = DEFAULT_LEVEL;

	// Reset crc32 value, buffer size, and end of file for
	// file to pack.
	//....................................................
	InitializeTables(COMP_TABLE);
	StuffLzwCode(NULL,NULL,0,RESET_ROUTINE);
	GetTheNextByte(NULL,NULL,RESET_ROUTINE);

	// Get the first character from the file and put in dwOldCode.
	//............................................................
	dwOldCode = GetTheNextByte(lpInFile,hInFile,NORMAL);
	if (dwOldCode == -1)
	{
		goto CompressEnd;
	}
	uliInCount.QuadPart++;
	uliFileIn.QuadPart++;
	liHalfPercent.QuadPart--;

	// Pack the current file.
	//.......................
	while(TRUE)
	{
		EmptyTheMessageQue();
		if (bCancelOperation == TRUE)
		{
			bResult = FALSE;
			goto CompressEnd;
		}
		dwTheNextByte = GetTheNextByte(lpInFile,hInFile,NORMAL);
		if (dwTheNextByte == -1)
		{
			bResult = FALSE;
			goto CompressEnd;
		}
		if (bEndOfFile)
		{
			break;
		}
		uliInCount.QuadPart++;
		uliFileIn.QuadPart++;
		liHalfPercent.QuadPart--;

		dwLzwCode = GetLzwCode(dwTheNextByte);

		if (dwLzwCode != IN_TABLE)
		{
			if (dwLzwCode >= dwCurrentLevel)
			{
				bResult = StuffLzwCode(lpOutFile,hOutFile,NEXT_CODE_SIZE,NORMAL);
				if (!bResult)
				{
					goto CompressEnd;
				}
				dwBitsInCode++;
				dwCurrentLevel <<= 1;
			}
			bResult = StuffLzwCode(lpOutFile,hOutFile,dwLzwCode,NORMAL);
			if (!bResult)
			{
				goto CompressEnd;
			}
			if (dwCodesUsed == dwResetCode)
			{
				bResult = StuffLzwCode(lpOutFile,hOutFile,dwResetCode,NORMAL);
				if (!bResult)
				{
					goto CompressEnd;
				}
				dwBitsInCode = DEFAULT_BITS;
				dwCurrentLevel = DEFAULT_LEVEL;
				InitializeTables(COMP_TABLE);
			}
		}
		if (liHalfPercent.QuadPart <= 0)
		{
			// Update the progress bar.
			//.........................
			SendMessage(GetDlgItem(hDialogModeLess,IDC_PROGRESS),PBM_STEPIT,0,0);
			liHalfPercent.QuadPart = liHalfPercentDup.QuadPart;
		}
	}
	// Do the last code for the file.
	//...............................
	bResult = StuffLzwCode(lpOutFile,hOutFile,dwOldCode,NORMAL);
	if (!bResult)
	{
		goto CompressEnd;
	}
	// Store the left over part of the last code, if there is any.
	//............................................................
	StuffLzwCode(lpOutFile,hOutFile,0,CLOSE);

	CompressEnd:

	return(bResult);
}

// Calculate a crc32 check value for a file header.
//.................................................
VOID CalculateHeaderCrc()
{
	LPBYTE		lpFileHeader;
	DWORD		dwCrcSize;
	DWORD		dwCrc32;

	lpFileHeader = (LPBYTE)&pfhdr;
	dwCrcSize = (sizeof(PACKED_FILE_HEADER) - 4);
	dwCrc32 = -1;

	__asm
	{
		mov		ecx,dwCrcSize
		mov		edi,lpFileHeader
	L1:	mov		al,byte ptr [edi]
		xor		al,byte ptr dwCrc32
		shr		dwCrc32,8
		movzx	edx,al
		mov		esi,lpCrc32Table
		mov		eax,dword ptr [esi][edx*4]
		xor		dwCrc32,eax
		inc		edi
		dec		ecx
		jnz		L1
		xor		dwCrc32,-1
	}
	pfhdr.dwHeaderCrc32 = dwCrc32;
}

// InitializeTable sets up the code and hash tables.
//..................................................
VOID InitializeTables(DWORD dwStatus)
{
	int			i;
	DWORD		dwScratch;
	LPTABLE		lpTable;

	lpTable = lpCodeTable;
	dwScratch = sizeof(TABLE);

	for (i = 0; i < 256; i++)
	{
		lpTable->CODE_C = 0;
		lpTable->SUFFIX = LOBYTE(LOWORD(i));
		__asm
		{
			mov		eax,dwScratch
			add		lpTable,eax
		}
	}
	dwCodesUsed = FIRST_CODE;

	// Setup the hash tables if we are compressing.
	//.............................................
	if (dwStatus == COMP_TABLE)
	{
		__asm
		{
			mov		eax,EMPTY
			mov		ecx,dwHashTableEntries
			mov		edi,lpHashTable
			rep		stosd
		}
	}
}

// StuffLzwCode puts a lzw code in the output buffer. Each code
// is 9 to 24 bits long. Returns FALSE for i/o error.
//.............................................................
BOOL StuffLzwCode(LPBYTE lpFile, HANDLE hFile, DWORD dwLzwCode, DWORD dwFlag)
{
	BOOL		bResult = TRUE;
	DWORD		dwBytesWritten;

	if (dwFlag == RESET_ROUTINE)
	{
		dwStuffPtr = 0;
		goto StuffEnd;
	}
	if (dwFlag == NORMAL)
	{
		// First setup pointer and index into the output buffer.
		//......................................................
		__asm
		{
			mov		edi,lpOutBuffer
			add		edi,dwStuffPtr
			mov		eax,dwLzwCode
			mov		ecx,iBitsLeft
			shl		eax,cl
			or		dwCodeHoldArea,eax
			mov		eax,dwBitsInCode
			add		iBitsLeft,eax
		}
		while(iBitsLeft >= 8)
		{
			__asm
			{
				mov		al,byte ptr dwCodeHoldArea
				stosb
				shr		dwCodeHoldArea,8
				sub		iBitsLeft,8
				inc		dwStuffPtr
				push	edi
			}
			uliOutCount.QuadPart++;
			pfhdr.uliCompressedFileSize.QuadPart++;
			uliFileOut.QuadPart++;

			__asm
			{
				pop		edi
			}
		}
		uliFileCodes.QuadPart++;
		uliTotalCodes.QuadPart++;
	}
	if (dwFlag == CLOSE || dwStuffPtr >= BUFFER_SIZE_IN)
	{
		// The next if statement will only apply on a close if
		// there are left over bits in a code to store. 
		// dwStuffPtr = bytes to write.
		//....................................................
		if (dwFlag == CLOSE && iBitsLeft > 0)
		{
			__asm
			{
				mov		edi,lpOutBuffer
				add		edi,dwStuffPtr
			}
			while(iBitsLeft > 0)
			{
				__asm
				{
					mov		al,byte ptr dwCodeHoldArea
					stosb
					shr		dwCodeHoldArea,8
					sub		iBitsLeft,8
					inc		dwStuffPtr
					push	edi
				}
				uliOutCount.QuadPart++;
				pfhdr.uliCompressedFileSize.QuadPart++;
				uliFileOut.QuadPart++;

				__asm
				{
					pop		edi
				}
			}
		}
		if (dwStuffPtr > 0)
		{
			bResult = WriteMyFile((LPTSTR)lpFile,hFile,lpOutBuffer,dwStuffPtr,
								   &dwBytesWritten,NULL);
			dwStuffPtr = 0;
		}
	}

	StuffEnd:

	return(bResult);
}

// GetTheNextByte gets the next byte from the input buffer.
// If the buffer is empty it reads in more of the file. If
// end of file, it sets bEndOfFile to TRUE. Returns -1
// for i/o error or the next byte in LOBYTE(LOWORD).
//.........................................................
DWORD GetTheNextByte(LPBYTE lpFile, HANDLE hFile, DWORD dwFlag)
{
	DWORD		dwResult = 0;
	DWORD		dwBytesRead;
	BOOL		bResult;

	if (dwFlag == RESET_ROUTINE)
	{
		dwSizeInBuffer = 0;
		bEndOfFile = FALSE;
		pfhdr.dwFileCrc32 = -1;
		goto GetByteEnd;
	}
	// If the buffer is empty, read characters from the file.
	//.......................................................
	if (!dwSizeInBuffer)
	{
		bResult = ReadMyFile((LPTSTR)lpFile,hFile,lpInBuffer,BUFFER_SIZE_IN,&dwBytesRead,NULL);
		if (!bResult)
		{
			dwResult = -1;
			goto GetByteEnd;
		}
		if (dwBytesRead == 0)
		{
			bEndOfFile = TRUE;
			goto GetByteEnd;
		}
		// Set the buffer size and reset the buffer pointer.
		//..................................................
		dwSizeInBuffer = dwBytesRead;
		dwGetPtr = 0;
	}
	// Get the next byte from the buffer.
	//...................................
	__asm
	{
		mov		edi,lpInBuffer
		add		edi,dwGetPtr
		xor		eax,eax
		mov		al,byte ptr [edi]
		mov		dwResult,eax

		// Calculate the crc32 integrity check.
		//.....................................
		mov		ebx,pfhdr.dwFileCrc32
		xor		al,bl
		shr		pfhdr.dwFileCrc32,8
		movzx	esi,al
		mov		edi,lpCrc32Table
		mov		edx,dword ptr [edi][esi*4]
		xor		pfhdr.dwFileCrc32,edx
		inc		dwGetPtr
		dec		dwSizeInBuffer
	}
	
	GetByteEnd:

	return(dwResult);
}

// GetLzwCode entered with the current character in dwChar
// and the old code in dwOldCode. Returns with lzw code or
// IN_TABLE indicating that the code already exists in the
// table.
//.........................................................
DWORD GetLzwCode(DWORD dwChar)
{
	DWORD			dwIdx;
	DWORD			dwHash;
	DWORD			dwOutPut;
	DWORD			dwHOffset;
	BYTE			Character;

	Character = LOBYTE(LOWORD(dwChar));

	__asm
	{
		mov		edi,lpHashTable

		// Do a hash function on the character and old code.
		// First shift character left and then xor with old code.
		// Use edi to index into hash table. Save hash code in hash.
		//..........................................................
		movzx	esi,Character
		mov		cl,CharacterShiftValue
		shl		esi,cl
		xor		esi,dwOldCode
		mov		dwHash,esi
		cmp		esi,0
		jne		L1
		mov		dwHOffset,1
		jmp		L2
	L1:	mov		eax,dwHashTableEntries
		sub		eax,esi
		mov		dwHOffset,eax

		// Get the hash table entry and save in dwIdx. If not EMPTY
		// check for empty spot in table, or a matching entry. If
		// matching entry return with dwOldCode = dwIdx and dwOutPut
		// = IN_TABLE.
		//..........................................................
	L2:	mov		eax,dword ptr [edi][esi*4]
		mov		dwIdx,eax

		// Setup dwOldCode and character for matching entry
		// comparision.
		//.................................................
		mov		edx,dwOldCode
		mov		bl,Character
	L3:	cmp		eax,EMPTY
		je		L6
		mov		esi,lpCodeTable

		// Index into table to see if matching entry. Since the size
		// of the table is 5, use the lea instruction to get the
		// offset.
		//..........................................................
		lea		ecx,[eax*4+eax]
		add		esi,ecx

		// If we have a matching entry.
		//.............................
		cmp		dword ptr [esi].CODE_C,edx
		jne		L4
		cmp		byte ptr [esi].SUFFIX,bl
		jne		L4
		mov		eax,dwIdx
		mov		dwOldCode,eax
		mov		dwOutPut,IN_TABLE
		jmp		GetLzwEnd;

		// The entry did not match. Look again.
		//.....................................
	L4:	mov		edi,lpHashTable
		mov		eax,dwHOffset
		sub		dwHash,eax
		jnc		L5
		mov		eax,dwHashTableEntries
		add		dwHash,eax
	L5:	mov		esi,dwHash
		mov		eax,dword ptr [edi][esi*4]
		mov		dwIdx,eax
		jmp		L3

		// No matching entry and found an empty position in
		// the hash table, therefore dwOutPut = dwOldCode.
		//..................................................
	L6:	mov		eax,dwOldCode
		mov		dwOutPut,eax

		// Put entries in code and hash tables.
		//.....................................
		mov		esi,lpCodeTable
		mov		eax,dwCodesUsed

		// Multiply by 5 to get offset in the table.
		//..........................................
		lea		ecx,[eax*4+eax]
		add		esi,ecx
		mov		eax,dwOldCode
		mov		dword ptr [esi].CODE_C,eax
		mov		bl,Character
		mov		byte ptr [esi].SUFFIX,bl
		mov		edi,lpHashTable
		mov		esi,dwHash
		mov		eax,dwCodesUsed
		mov		dword ptr [edi][esi*4],eax
		inc		dwCodesUsed

		// Put character into dwOldCode and return dwOutPut.
		//..................................................
		movzx	eax,Character
		mov		dwOldCode,eax
	}

	GetLzwEnd:

	return(dwOutPut);
}

// Check the header crc32 value for a packed file.
//................................................
BOOL CheckHeaderCrc()
{
	DWORD		dwHeaderSize;
	BOOL		bResult = TRUE;

	dwCheckCrc32 = -1;
	dwHeaderSize = (sizeof(PACKED_FILE_HEADER) - 4);

	__asm
	{
		mov		edi,offset pfhdr
		mov		ecx,dwHeaderSize
	L1:	mov		al,byte ptr [edi]
		xor		al,byte ptr dwCheckCrc32
		shr		dwCheckCrc32,8
		movzx	esi,al
		mov		ebx,lpCrc32Table
		mov		edx,dword ptr [ebx][esi*4]
		xor		dwCheckCrc32,edx
		inc		edi
		dec		ecx
		jnz		L1
		xor		dwCheckCrc32,-1
	}
	if (dwCheckCrc32 != pfhdr.dwHeaderCrc32)
	{
		SetLastError(IDS_BADHEADERCRC32);
		ErrorProcedure((LPTSTR)&szFileName,IDS_READ,MB_OK);
		bResult = FALSE;
	}
	return(bResult);
}

// CALLBACK procedure for the ask if we want to overwrite dialog box
// while unpacking a file.
//...................................................................
LRESULT CALLBACK AskOverwriteUnpackProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			LARGE_INTEGER		li;
			WIN32_FIND_DATA		FindData;
			TCHAR				szInBuffer[332];
			TCHAR				szFormatedNumber[64];
			HANDLE				hSearchHandle;
			FILETIME			ftLocalTime;
			SYSTEMTIME			stLocalTime;
			TCHAR				szLocalDate[128];
			TCHAR				szLocalTime[64];

			// Clear a few variables.
			//.......................
			ZeroMemory(&szFormatedNumber,sizeof(szFormatedNumber));
			ZeroMemory(&szLocalDate,sizeof(szLocalDate));
			ZeroMemory(&szLocalTime,sizeof(szLocalTime));
			ZeroMemory(&szInBuffer,sizeof(szInBuffer));

			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);

			// Setup the dialog box.
			//......................
			SetDlgItemTextFmt(hDlg,IDC_CONTAINS,
							 (LPCTSTR)GetDisplayName(&shfi1,(LPCTSTR)&szDestination));

			// Setup the icons for the files. Use hIcon.
			//...............................
			SendMessage(GetDlgItem(hDlg,IDC_ICON1),STM_SETICON,(WPARAM)hIcon,0);
			SendMessage(GetDlgItem(hDlg,IDC_ICON2),STM_SETICON,(WPARAM)hIcon,0);

			ZeroMemory(&szInBuffer,sizeof(szInBuffer));

			// Setup the file information for each file.
			// Do the destination file first.
			//..........................................
			hSearchHandle = FindFirstFile((LPCTSTR)&szDestination,&FindData);
			FindClose(hSearchHandle);
			li.LowPart = FindData.nFileSizeLow;
			li.HighPart = FindData.nFileSizeHigh;
			_i64toa(li.QuadPart,(LPBYTE)&szInBuffer,10);
			GetNumberFormat(LOCALE_USER_DEFAULT,0,(LPCTSTR)&szInBuffer,
				            &nFormatInfo,(LPTSTR)&szFormatedNumber,sizeof(szFormatedNumber));
			StringCbPrintf(szInBuffer,sizeof(szInBuffer),lpszSizeFormat,szFormatedNumber);
			SetDlgItemText(hDlg,IDC_SIZE1,(LPCTSTR)szInBuffer);
			ZeroMemory(&szInBuffer,sizeof(szInBuffer));

			// Now do the time and date.
			//..........................
			FileTimeToLocalFileTime((LPFILETIME)&FindData.ftLastWriteTime,
									(LPFILETIME)&ftLocalTime);
			FileTimeToSystemTime((LPFILETIME)&ftLocalTime,(LPSYSTEMTIME)&stLocalTime);
			// Format the date.
			//.................
			GetDateFormat(LOCALE_USER_DEFAULT,DATE_LONGDATE,&stLocalTime,
				          NULL,(LPTSTR)&szLocalDate,sizeof(szLocalDate));

			// Format the time.
			//.................
			GetTimeFormat(LOCALE_USER_DEFAULT,TIME_FORCE24HOURFORMAT,
						  &stLocalTime,NULL,(LPTSTR)&szLocalTime,sizeof(szLocalTime));
			StringCbPrintf(szInBuffer,sizeof(szInBuffer),lpszDateTimeFormat,&szLocalDate,
						   &szLocalTime);
			SetDlgItemText(hDlg,IDC_DATETIME1,(LPCTSTR)szInBuffer);

			// Clear a few variables.
			//.......................
			ZeroMemory(&szFormatedNumber,sizeof(szFormatedNumber));
			ZeroMemory(&szLocalDate,sizeof(szLocalDate));
			ZeroMemory(&szLocalTime,sizeof(szLocalTime));
			ZeroMemory(&szInBuffer,sizeof(szInBuffer));

			// Setup the information for the source file which
			// is in the packed file.
			//................................................
			_i64toa(pfhdr.uliFileSize.QuadPart,(LPBYTE)&szInBuffer,10);
			GetNumberFormat(LOCALE_USER_DEFAULT,0,(LPCTSTR)&szInBuffer,
				            &nFormatInfo,(LPTSTR)&szFormatedNumber,sizeof(szFormatedNumber));
			StringCbPrintf(szInBuffer,sizeof(szInBuffer),lpszSizeFormat,szFormatedNumber);
			SetDlgItemText(hDlg,IDC_SIZE2,(LPCTSTR)szInBuffer);
			ZeroMemory(&szInBuffer,sizeof(szInBuffer));

			// Now do the time and date.
			//..........................
			FileTimeToLocalFileTime((LPFILETIME)&pfhdr.ftLastWrite,(LPFILETIME)&ftLocalTime);
			FileTimeToSystemTime((LPFILETIME)&ftLocalTime,(LPSYSTEMTIME)&stLocalTime);
			// Format the date.
			//.................
			GetDateFormat(LOCALE_USER_DEFAULT,DATE_LONGDATE,&stLocalTime,
				          NULL,(LPTSTR)&szLocalDate,sizeof(szLocalDate));

			// Format the time.
			//.................
			GetTimeFormat(LOCALE_USER_DEFAULT,TIME_FORCE24HOURFORMAT,
						  &stLocalTime,NULL,(LPTSTR)&szLocalTime,sizeof(szLocalTime));
			StringCbPrintf(szInBuffer,sizeof(szInBuffer),lpszDateTimeFormat,&szLocalDate,
						   &szLocalTime);
			SetDlgItemText(hDlg,IDC_DATETIME2,(LPCTSTR)szInBuffer);

			// If we only have one file, disable the Yes to All button.
			//.........................................................
			if (iNumberOfFiles == 1)
			{
				EnableWindow(GetDlgItem(hDlg,IDC_YESTOALL),FALSE);
			}
			// Center the window.
			//...................
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			return(TRUE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{

				case IDC_MYYES:
				{
					EndDialog(hDlg,IDC_MYYES);
				}
				break;

				case IDC_YESTOALL:
				{
					bOverWriteAll = TRUE;
					EndDialog(hDlg,IDC_YESTOALL);
				}
				break;

				case IDC_MYNO:
				{
					EndDialog(hDlg,IDC_MYNO);
				}
				break;

				case IDCANCEL:
				{
					EndDialog(hDlg,IDCANCEL);
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
			break;
		}

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;
	
		default:
			return(FALSE);
	}
	return(TRUE);
}

// Main decompression procedures. Returns FALSE for i/o error.
// If hOutFile is 0, do not write any output to disk. Used for
// testing the integrity of the packed file.
//............................................................
BOOL DecompressTheFile(LPBYTE lpInFile, HANDLE hInFile, LPBYTE lpOutFile, HANDLE hOutFile)
{
	DWORD		dwCode;
	BOOL		bResult = FALSE;

	// Setup a few variables.
	//.......................
	bEndOfFile = FALSE;

	lpStackPointer = lpPStack;
	dwBufferCount = 0;
	dwBufferSize = 0;
	Temp = 0;
	dwOutPutCount = 0;
	dwCheckCrc32 = -1;
	dwCodeHoldArea = 0;
	dwBitsLeft = 0;
	dwBitsInCode = DEFAULT_BITS;

	// Initialize the tables and get the first code from the file.
	//............................................................
	InitializeTables(DECOMP);
	dwOldCode = GetTheCode(lpInFile,hInFile);
	if (dwOldCode == -1)
	{
		goto DecompEnd;
	}
	// It should never happen, but check for end of file anyway.
	// Could have a corrupted file.
	//..........................................................
	if (bEndOfFile)
	{
		goto DecompEnd;
	}
	LastByte = LOBYTE(LOWORD(dwOldCode));
	StuffCharacter(LastByte);
	bResult = UnStuffBuffer(lpOutFile,hOutFile);
	if (!bResult)
	{
		goto DecompEnd;
	}
	// While we still have codes in the file to decompress.
	//.....................................................
	while(TRUE)
	{
		EmptyTheMessageQue();
		if (bCancelOperation == TRUE)
		{
			bResult = FALSE;
			goto DecompEnd;
		}
		dwCode = GetTheCode(lpInFile,hInFile);
		if (dwCode == -1)
		{
			bResult = FALSE;
			goto DecompEnd;
		}
		// If we have an end of file, flush the output buffer to disk.
		//............................................................
		if (bEndOfFile)
		{
			bResult = DoOutput(lpOutFile,hOutFile);
			if (!bResult)
			{
				goto DecompEnd;
			}
			break;
		}
		// If we have code 256 increase the code bit size.
		//................................................
		if (dwCode == NEXT_CODE_SIZE)
		{
			dwBitsInCode++;
			continue;
		}
		// Check for the reset code. Means code table is full.
		// Reinitialize the tables.
		//....................................................
		if (dwCode == dwResetCode)
		{
			InitializeTables(DECOMP);
			dwBitsInCode = DEFAULT_BITS;
			dwOldCode = GetTheCode(lpInFile,hInFile);
			if (dwOldCode == -1)
			{
				goto DecompEnd;
			}
			LastByte = LOBYTE(LOWORD(dwOldCode));
			StuffCharacter(LastByte);
			bResult = UnStuffBuffer(lpOutFile,hOutFile);
			if (!bResult)
			{
				goto DecompEnd;
			}
			continue;
		}
		// Main procedure to decode codes and put them in the
		// output buffer.
		//...................................................
		dwInCode = dwCode;

		// If the code is not in the table, it is a special class of
		// of code for a certain type of repetitive strings. The code
		// can be transmitted before it exists. Use the last byte and
		// old code to construct this string.
		//...........................................................
		if (dwCode >= dwCodesUsed)
		{
			dwCode = dwOldCode;
			StuffCharacter(LastByte);
		}
		// Stuff characters on the pseudo stack until the code
		// is less than 256.
		//....................................................
		__asm
		{
			mov		eax,dwCode
		L1:	mov		esi,lpCodeTable
			lea		ecx,[eax*4+eax]
			add		esi,ecx
			cmp		eax,256
			jb		L2
			mov		bl,byte ptr [esi].SUFFIX
			mov		LastByte,bl
			push	esi
		}
		StuffCharacter(LastByte);
		__asm
		{
			pop		esi
			mov		eax,dword ptr [esi].CODE_C
			jmp		L1
		L2:	mov		bl,byte ptr [esi].SUFFIX
			mov		LastByte,bl
		}
		StuffCharacter(LastByte);
		bResult = UnStuffBuffer(lpOutFile,hOutFile);
		if (!bResult)
		{
			goto DecompEnd;
		}
		// Add the code and suffix to the code table.
		//...........................................
		__asm
		{
			mov		esi,lpCodeTable
			mov		eax,dwCodesUsed
			lea		ecx,[eax*4+eax]
			add		esi,ecx
			mov		eax,dwOldCode
			mov		dword ptr [esi].CODE_C,eax
			mov		al,LastByte
			mov		byte ptr [esi].SUFFIX,al
			inc		dwCodesUsed

			// Set dwOldCode to dwInCode for the next code to process.
			//........................................................
			mov		eax,dwInCode
			mov		dwOldCode,eax
		}
		if (liHalfPercent.QuadPart <= 0)
		{
			// Update the progress bar.
			//.........................
			SendMessage(GetDlgItem(hDialogModeLess,IDC_PROGRESS),PBM_STEPIT,0,0);
			liHalfPercent.QuadPart = liHalfPercentDup.QuadPart;
		}
	}	//	while(TRUE)

	DecompEnd:

	return(bResult);
}

// GetTheCode gets bytes from the input buffer. Returns a 9 to 24
// lzw code. Returns -1 if i/o error.
//...............................................................
DWORD GetTheCode(LPBYTE lpInFile, HANDLE hInFile)
{
	BOOL		bResult;
	DWORD		dwResult = 0;

	// While there are still bits to get, make a 9 to 24 bit code.
	//............................................................
	while(dwBitsLeft < dwBitsInCode)
	{
		bResult = GetOneByte(lpInFile,hInFile);
		if (!bResult)
		{
			dwResult = -1;
			goto CodeEnd;
		}
		if (bEndOfFile)
		{
			goto CodeEnd;
		}
		__asm
		{
			movzx	eax,Temp
			mov		ecx,dwBitsLeft
			shl		eax,cl
			or		dwCodeHoldArea,eax
			add		dwBitsLeft,8
		}
	}
	// Mask off the proper number of bits and return the lzw code.
	//............................................................
	__asm
	{
		mov		edi,dwBitsInCode
		mov		eax,dwCodeHoldArea
		sub		edi,DEFAULT_BITS
		and		eax,dwBitMask[edi*4]
		mov		dwResult,eax

		// Shift the bits used out of dwCodeHoldArea and set dwBitsLeft.
		//..............................................................
		mov		ecx,dwBitsInCode
		sub		dwBitsLeft,ecx
		shr		dwCodeHoldArea,cl
	}

	CodeEnd:

	return(dwResult);
}

// GetOneByte gets one byte from the input buffer and places it in
// Temp. If the buffer is empty, it reads more into the input
// buffer. If eof it set bEndOfFile to true. Returns FALSE for
// i/o error.
//................................................................
BOOL GetOneByte(LPBYTE lpInFile, HANDLE hInFile)
{
	DWORD		dwBytesToRead;
	DWORD		dwBytesRead;
	BOOL		bResult = TRUE;

	if (pfhdr.uliCompressedFileSize.QuadPart == 0)
	{
		bEndOfFile = TRUE;
	}
	else
	{
		// If the buffer is empty read in more from the file.
		//...................................................
		if (dwBufferCount == dwBufferSize)
		{
			if (pfhdr.uliCompressedFileSize.QuadPart >= BUFFER_SIZE_IN)
			{
				dwBytesToRead = BUFFER_SIZE_IN;
			}
			else
			{
				dwBytesToRead = pfhdr.uliCompressedFileSize.LowPart;
			}
			bResult = ReadMyFile((LPTSTR)lpInFile,hInFile,lpInBuffer,
								  dwBytesToRead,&dwBytesRead,NULL);

			// If we did not read in the required number of bytes.
			//....................................................
			if (dwBytesRead != dwBytesToRead)
			{
				SetLastError(IDS_BYTESREADNOTEQUALTOREQUEST);
				ErrorProcedure((LPTSTR)lpInFile,IDS_READ,MB_OK);
				bResult = FALSE;
				goto OneByteEnd;
			}
			if (!bResult)
			{
				goto OneByteEnd;
			}
			// Reset buffer size and output count.
			//....................................
			dwBufferSize = dwBytesRead;
			dwBufferCount = 0;
		}
		// Return the next byte from the buffer in Temp.
		//..............................................
		__asm
		{
			mov		edi,lpInBuffer
			add		edi,dwBufferCount
			mov		al,byte ptr [edi]
			inc		dwBufferCount
			mov		Temp,al
		}
		pfhdr.uliCompressedFileSize.QuadPart--;
		liHalfPercent.QuadPart--;
	}

	OneByteEnd:

	return(bResult);
}

// StuffCharacter stuffs a decompressed character onto the pseudo stack.
//......................................................................
VOID StuffCharacter(BYTE MyChar)
{
	__asm
	{
		mov		esi,lpStackPointer
		inc		lpStackPointer
		mov		al,MyChar
		mov		byte ptr [esi],al
	}
}

// UnStuffBuffer takes the characters off the pseudo stack in reverse
// order and places them in the output buffer. If the output buffer
// gets full it is written to disk. Calculates crc32 check value.
// Returns FALSE for i/o error.
//...................................................................
BOOL UnStuffBuffer(LPBYTE lpOutFile, HANDLE hOutFile)
{
	BOOL		bResult = TRUE;

	// While characters are on the stack,put them in the output buffer.
	//.................................................................
	while(TRUE)
	{
		lpStackPointer--;
		if (lpStackPointer < lpPStack)
		{
			break;
		}
		if (dwOutPutCount == BUFFER_SIZE_IN)
		{
			bResult = DoOutput(lpOutFile,hOutFile);
			if (!bResult)
			{
				goto UnStuffEnd;
			}
		}
		// Do the crc32 calculation here.
		//...............................
		__asm
		{
			mov		esi,lpStackPointer
			mov		al,byte ptr [esi]
			mov		bl,al
			xor		bl,byte ptr dwCheckCrc32
			shr		dwCheckCrc32,8
			movzx	edi,bl
			mov		ebx,lpCrc32Table
			mov		edx,dword ptr [ebx][edi*4]
			xor		dwCheckCrc32,edx

			// Put the character in the output buffer.
			//........................................
			mov		edi,lpOutBuffer
			add		edi,dwOutPutCount
			inc		dwOutPutCount
			stosb
		}
	}
	lpStackPointer = lpPStack;

	UnStuffEnd:

	return(bResult);
}

// DoOutput writes the output buffer to disk. If the output handle
// is 0 just zero the output count. Used for testing the packed file.
// Returns FALSE for i/o error.
//...................................................................
BOOL DoOutput(LPBYTE lpOutFile, HANDLE hOutFile)
{
	DWORD		dwBytesWritten;
	BOOL		bResult = TRUE;

	if (dwOutPutCount != 0)
	{
		if (hOutFile != 0)
		{
			bResult = WriteMyFile((LPTSTR)lpOutFile,hOutFile,lpOutBuffer,
								   dwOutPutCount,&dwBytesWritten,NULL);
		}
		dwOutPutCount = 0;
	}
	return(bResult);
}

// Check to see if we have a valid packed file. If we do, return the handle.
//..........................................................................
HANDLE IsValidPackedFile(LPBYTE lpFileName, BOOL bShowError)
{
	BOOL		bResult = FALSE;
	HANDLE		hFile;
	DWORD		dwBytesRead;

	hFile = CreateMyFile((LPTSTR)lpFileName,GENERIC_READ,0,NULL,OPEN_EXISTING,
						  FILE_ATTRIBUTE_NORMAL,NULL);
	if (!hFile)
	{
		goto CheckEnd;
	}
	bResult = ReadMyFile((LPTSTR)lpFileName,hFile,&pfidhdr,
						  sizeof(PACKED_FILE_ID_HDR),&dwBytesRead,NULL);
	if (!bResult)
	{
		goto CheckEnd;
	}
	bResult = SearchFor((LPBYTE)&PackedFileId,lstrlen(PackedFileId),(LPBYTE)&pfidhdr,4);

	// If we did not have a match, search for the alternate id.
	//.........................................................
	if (!bResult)
	{
		bResult = SearchFor((LPBYTE)&PackedFileId1,lstrlen(PackedFileId1),(LPBYTE)&pfidhdr,4);
	}
	if (bResult)
	{
		bWeHaveLzw = TRUE;
		goto CheckEnd;
	}
	// See if the zip algorithm.
	//..........................
	if (!bResult)
	{
		bResult = SearchFor((LPBYTE)&PackedFileIdZ,lstrlen(PackedFileId1),(LPBYTE)&pfidhdr,4);
	}
	if (bResult)
	{
		bWeHaveLzw = FALSE;
		goto CheckEnd;
	}
	// We do not have a valid packed file.
	//....................................
	if (bShowError)
	{
		SetLastError(IDS_INVALIDPACKEDFILE);
		ErrorProcedure((LPTSTR)lpFileName,IDS_READ,MB_OK);
	}
	// Close the file and try again.
	//..............................
	bResult = CloseMyHandle((LPTSTR)lpFileName,hFile);
	if (!bResult)
	{
		goto CheckEnd;
	}
	hFile = 0;

	CheckEnd:

	return(hFile);
}

// Check to see if a file is already compressed.
//..............................................
BOOL IsFileAlreadyPacked(LPBYTE lpFile)
{
	BOOL		bResult;

	bResult = PathMatchSpec((LPCTSTR)lpFile,lpszPkdFile);
	
	return(bResult);
}
